/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authorization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authorization.LdapUserAttributesToRolesAuthorizationGenerator;
import org.apereo.cas.authorization.LdapUserGroupsToRolesAuthorizationGenerator;
import org.apereo.cas.configuration.model.core.monitor.LdapSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthorizationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.LoggingUtils;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.Credential;
import org.ldaptive.LdapEntry;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperation;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class EndpointLdapAuthenticationProvider
implements AuthenticationProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointLdapAuthenticationProvider.class);
    private final LdapSecurityActuatorEndpointsMonitorProperties ldapProperties;
    private final SecurityProperties securityProperties;
    private final ConnectionFactory connectionFactory;
    private final Authenticator authenticator;

    private static Authentication generateAuthenticationToken(Authentication authentication, List<SimpleGrantedAuthority> authorities) {
        String username = authentication.getPrincipal().toString();
        Object credentials = authentication.getCredentials();
        return new UsernamePasswordAuthenticationToken((Object)username, credentials, authorities);
    }

    public void destroy() {
        this.connectionFactory.close();
        this.authenticator.close();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            String username = authentication.getPrincipal().toString();
            Object credentials = authentication.getCredentials();
            String password = Optional.ofNullable(credentials).map(Object::toString).orElse(null);
            if (StringUtils.isBlank((CharSequence)password)) {
                throw new IllegalArgumentException("Password cannot be blank");
            }
            LOGGER.debug("Preparing LDAP authentication request for user [{}]", (Object)username);
            AuthenticationRequest request = new AuthenticationRequest(username, new Credential(password), ReturnAttributes.ALL.value());
            LOGGER.debug("Executing LDAP authentication request for user [{}]", (Object)username);
            AuthenticationResponse response = this.authenticator.authenticate(request);
            LOGGER.debug("LDAP response: [{}]", (Object)response);
            if (response.isSuccess()) {
                List requiredRoles = this.securityProperties.getUser().getRoles().stream().map(role -> StringUtils.prependIfMissing((String)role, (CharSequence)this.ldapProperties.getLdapAuthz().getRolePrefix(), (CharSequence[])new CharSequence[0])).map(String::toUpperCase).collect(Collectors.toList());
                LOGGER.debug("Required roles are [{}]", requiredRoles);
                if (requiredRoles.isEmpty()) {
                    LOGGER.info("No user security roles are defined to enable authorization. User [{}] is considered authorized", (Object)username);
                    return EndpointLdapAuthenticationProvider.generateAuthenticationToken(authentication, new ArrayList<SimpleGrantedAuthority>());
                }
                LdapEntry entry = response.getLdapEntry();
                HashMap attributes = new HashMap();
                entry.getAttributes().forEach(attribute -> attributes.put(attribute.getName(), new ArrayList(attribute.getStringValues())));
                Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(username, attributes);
                Function<Principal, List<SimpleGrantedAuthority>> authZGen = this.buildAuthorizationGenerator();
                List<SimpleGrantedAuthority> authorities = authZGen.apply(principal);
                LOGGER.debug("List of authorities remapped from profile roles are [{}]", authorities);
                if (authorities.stream().anyMatch(authority -> requiredRoles.contains(authority.getAuthority()))) {
                    return EndpointLdapAuthenticationProvider.generateAuthenticationToken(authentication, authorities);
                }
                LOGGER.warn("User [{}] is not authorized to access the requested resource", (Object)username);
            } else {
                LOGGER.warn("LDAP authentication response produced no results for [{}]", (Object)username);
            }
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new InsufficientAuthenticationException("Unexpected LDAP error", e);
        }
        throw new BadCredentialsException("Could not authenticate provided credentials");
    }

    public boolean supports(Class<?> aClass) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(aClass);
    }

    private Function<Principal, List<SimpleGrantedAuthority>> buildAuthorizationGenerator() {
        LdapAuthorizationProperties properties = this.ldapProperties.getLdapAuthz();
        if (this.isGroupBasedAuthorization()) {
            LOGGER.debug("Handling LDAP authorization based on groups");
            return new LdapUserGroupsToRolesAuthorizationGenerator(this.ldapAuthorizationGeneratorUserSearchOperation(this.connectionFactory), properties.isAllowMultipleResults(), properties.getGroupAttribute(), properties.getGroupPrefix(), this.ldapAuthorizationGeneratorGroupSearchOperation(this.connectionFactory));
        }
        if (this.isUserBasedAuthorization()) {
            LOGGER.debug("Handling LDAP authorization based on attributes and roles");
            return new LdapUserAttributesToRolesAuthorizationGenerator(this.ldapAuthorizationGeneratorUserSearchOperation(this.connectionFactory), properties.isAllowMultipleResults(), properties.getRoleAttribute(), properties.getRolePrefix());
        }
        List roles = this.securityProperties.getUser().getRoles();
        LOGGER.info("Authorization will generate static roles based on [{}]", (Object)roles);
        return principal -> roles.stream().map(String::toUpperCase).map(role -> StringUtils.prependIfMissing((String)role, (CharSequence)"ROLE_", (CharSequence[])new CharSequence[0])).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    private boolean isGroupBasedAuthorization() {
        LdapAuthorizationProperties properties = this.ldapProperties.getLdapAuthz();
        return StringUtils.isNotBlank((CharSequence)properties.getGroupFilter()) && StringUtils.isNotBlank((CharSequence)properties.getGroupAttribute());
    }

    private boolean isUserBasedAuthorization() {
        LdapAuthorizationProperties properties = this.ldapProperties.getLdapAuthz();
        return StringUtils.isNotBlank((CharSequence)properties.getBaseDn()) && StringUtils.isNotBlank((CharSequence)properties.getSearchFilter());
    }

    private SearchOperation ldapAuthorizationGeneratorUserSearchOperation(ConnectionFactory factory) {
        LdapAuthorizationProperties properties = this.ldapProperties.getLdapAuthz();
        SearchOperation searchOperation = LdapUtils.newLdaptiveSearchOperation(properties.getBaseDn(), properties.getSearchFilter(), new ArrayList<String>(), CollectionUtils.wrap((Object)properties.getRoleAttribute()));
        searchOperation.setConnectionFactory(factory);
        return searchOperation;
    }

    private SearchOperation ldapAuthorizationGeneratorGroupSearchOperation(ConnectionFactory factory) {
        LdapAuthorizationProperties properties = this.ldapProperties.getLdapAuthz();
        SearchOperation searchOperation = LdapUtils.newLdaptiveSearchOperation(properties.getGroupBaseDn(), properties.getGroupFilter(), new ArrayList<String>(), CollectionUtils.wrap((Object)properties.getGroupAttribute()));
        searchOperation.setConnectionFactory(factory);
        return searchOperation;
    }

    @Generated
    public EndpointLdapAuthenticationProvider(LdapSecurityActuatorEndpointsMonitorProperties ldapProperties, SecurityProperties securityProperties, ConnectionFactory connectionFactory, Authenticator authenticator) {
        this.ldapProperties = ldapProperties;
        this.securityProperties = securityProperties;
        this.connectionFactory = connectionFactory;
        this.authenticator = authenticator;
    }
}

