/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.CASSPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.OIDCRPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SPClientAppDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.am.CASSPClientApp;
import org.apache.syncope.core.persistence.api.entity.am.ClientApp;
import org.apache.syncope.core.persistence.api.entity.am.ClientAppUtils;
import org.apache.syncope.core.persistence.api.entity.am.ClientAppUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.am.OIDCRPClientApp;
import org.apache.syncope.core.persistence.api.entity.am.SAML2SPClientApp;
import org.apache.syncope.core.provisioning.api.data.ClientAppDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class ClientAppLogic
extends AbstractTransactionalLogic<ClientAppTO> {
    protected final ServiceOps serviceOps;
    protected final ClientAppUtilsFactory clientAppUtilsFactory;
    protected final ClientAppDataBinder binder;
    protected final CASSPClientAppDAO casSPClientAppDAO;
    protected final OIDCRPClientAppDAO oidcRPClientAppDAO;
    protected final SAML2SPClientAppDAO saml2SPClientAppDAO;

    public ClientAppLogic(ServiceOps serviceOps, ClientAppUtilsFactory clientAppUtilsFactory, ClientAppDataBinder binder, CASSPClientAppDAO casSPClientAppDAO, OIDCRPClientAppDAO oidcRPClientAppDAO, SAML2SPClientAppDAO saml2SPClientAppDAO) {
        this.serviceOps = serviceOps;
        this.clientAppUtilsFactory = clientAppUtilsFactory;
        this.binder = binder;
        this.casSPClientAppDAO = casSPClientAppDAO;
        this.oidcRPClientAppDAO = oidcRPClientAppDAO;
        this.saml2SPClientAppDAO = saml2SPClientAppDAO;
    }

    @PreAuthorize(value="hasRole('CLIENTAPP_LIST')")
    public <T extends ClientAppTO> List<T> list(ClientAppType type) {
        return (switch (type) {
            case ClientAppType.OIDCRP -> this.oidcRPClientAppDAO.findAll().stream().map(arg_0 -> ((ClientAppDataBinder)this.binder).getClientAppTO(arg_0));
            case ClientAppType.CASSP -> this.casSPClientAppDAO.findAll().stream().map(arg_0 -> ((ClientAppDataBinder)this.binder).getClientAppTO(arg_0));
            default -> this.saml2SPClientAppDAO.findAll().stream().map(arg_0 -> ((ClientAppDataBinder)this.binder).getClientAppTO(arg_0));
        }).toList();
    }

    protected void checkType(ClientAppType type, ClientAppUtils clientAppUtils) {
        if (clientAppUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + String.valueOf(type) + ", expected " + String.valueOf(clientAppUtils.getType()));
            throw sce;
        }
    }

    @PreAuthorize(value="hasRole('CLIENTAPP_READ')")
    @Transactional(readOnly=true)
    public <T extends ClientAppTO> T read(ClientAppType type, String key) {
        switch (type) {
            case OIDCRP: {
                OIDCRPClientApp oidcrp = (OIDCRPClientApp)this.oidcRPClientAppDAO.findById(key).orElseThrow(() -> new NotFoundException("OIDCRPClientApp " + key));
                this.checkType(type, this.clientAppUtilsFactory.getInstance((ClientApp)oidcrp));
                return (T)this.binder.getClientAppTO((ClientApp)oidcrp);
            }
            case CASSP: {
                CASSPClientApp cassp = (CASSPClientApp)this.casSPClientAppDAO.findById(key).orElseThrow(() -> new NotFoundException("CASSPClientApp " + key));
                this.checkType(type, this.clientAppUtilsFactory.getInstance((ClientApp)cassp));
                return (T)this.binder.getClientAppTO((ClientApp)cassp);
            }
        }
        SAML2SPClientApp saml2sp = (SAML2SPClientApp)this.saml2SPClientAppDAO.findById(key).orElseThrow(() -> new NotFoundException("SAML2SPClientApp " + key));
        this.checkType(type, this.clientAppUtilsFactory.getInstance((ClientApp)saml2sp));
        return (T)this.binder.getClientAppTO((ClientApp)saml2sp);
    }

    @PreAuthorize(value="hasRole('CLIENTAPP_CREATE')")
    public <T extends ClientAppTO> T create(ClientAppType type, ClientAppTO clientAppTO) {
        this.checkType(type, this.clientAppUtilsFactory.getInstance(clientAppTO));
        switch (type) {
            case OIDCRP: {
                return (T)this.binder.getClientAppTO((ClientApp)this.oidcRPClientAppDAO.save((Entity)((OIDCRPClientApp)this.binder.create(clientAppTO))));
            }
            case CASSP: {
                return (T)this.binder.getClientAppTO((ClientApp)this.casSPClientAppDAO.save((Entity)((CASSPClientApp)this.binder.create(clientAppTO))));
            }
        }
        return (T)this.binder.getClientAppTO((ClientApp)this.saml2SPClientAppDAO.save((Entity)((SAML2SPClientApp)this.binder.create(clientAppTO))));
    }

    @PreAuthorize(value="hasRole('CLIENTAPP_CREATE')")
    public <T extends ClientAppTO> T update(ClientAppType type, ClientAppTO clientAppTO) {
        this.checkType(type, this.clientAppUtilsFactory.getInstance(clientAppTO));
        switch (type) {
            case OIDCRP: {
                OIDCRPClientApp oidcrp = (OIDCRPClientApp)this.oidcRPClientAppDAO.findById(clientAppTO.getKey()).orElseThrow(() -> new NotFoundException("OIDCRPClientApp " + clientAppTO.getKey()));
                this.binder.update((ClientApp)oidcrp, clientAppTO);
                return (T)this.binder.getClientAppTO((ClientApp)this.oidcRPClientAppDAO.save((Entity)oidcrp));
            }
            case CASSP: {
                CASSPClientApp cassp = (CASSPClientApp)this.casSPClientAppDAO.findById(clientAppTO.getKey()).orElseThrow(() -> new NotFoundException("CASSPClientApp " + clientAppTO.getKey()));
                this.binder.update((ClientApp)cassp, clientAppTO);
                return (T)this.binder.getClientAppTO((ClientApp)this.casSPClientAppDAO.save((Entity)cassp));
            }
        }
        SAML2SPClientApp saml2sp = (SAML2SPClientApp)this.saml2SPClientAppDAO.findById(clientAppTO.getKey()).orElseThrow(() -> new NotFoundException("SAML2SPClientApp " + clientAppTO.getKey()));
        this.binder.update((ClientApp)saml2sp, clientAppTO);
        return (T)this.binder.getClientAppTO((ClientApp)this.saml2SPClientAppDAO.save((Entity)saml2sp));
    }

    @PreAuthorize(value="hasRole('CLIENTAPP_DELETE')")
    public <T extends ClientAppTO> T delete(ClientAppType type, String key) {
        return (T)(switch (type) {
            case ClientAppType.OIDCRP -> {
                OIDCRPClientApp oidcrp = (OIDCRPClientApp)this.oidcRPClientAppDAO.findById(key).orElseThrow(() -> new NotFoundException("OIDCRPClientApp " + key));
                this.oidcRPClientAppDAO.delete((Entity)oidcrp);
                yield this.binder.getClientAppTO((ClientApp)oidcrp);
            }
            case ClientAppType.CASSP -> {
                CASSPClientApp cassp = (CASSPClientApp)this.casSPClientAppDAO.findById(key).orElseThrow(() -> new NotFoundException("CASSPClientApp " + key));
                this.casSPClientAppDAO.delete((Entity)cassp);
                yield this.binder.getClientAppTO((ClientApp)cassp);
            }
            default -> {
                SAML2SPClientApp saml2sp = (SAML2SPClientApp)this.saml2SPClientAppDAO.findById(key).orElseThrow(() -> new NotFoundException("SAML2SPClientApp " + key));
                this.saml2SPClientAppDAO.delete((Entity)saml2sp);
                yield this.binder.getClientAppTO((ClientApp)saml2sp);
            }
        });
    }

    protected ClientAppTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        if (ArrayUtils.isEmpty((Object[])args) || args.length != 2) {
            throw new UnresolvedReferenceException();
        }
        try {
            String key;
            ClientAppType clientAppType;
            Object object = args[0];
            if (!(object instanceof ClientAppType)) {
                throw new RuntimeException("Invalid ClientApp type");
            }
            ClientAppType type = clientAppType = (ClientAppType)object;
            Object object2 = args[1];
            if (object2 instanceof String) {
                String string;
                key = string = (String)object2;
            } else {
                object2 = args[1];
                if (object2 instanceof ClientAppTO) {
                    ClientAppTO clientAppTO = (ClientAppTO)object2;
                    key = clientAppTO.getKey();
                } else {
                    throw new RuntimeException("Invalid ClientApp key");
                }
            }
            return this.binder.getClientAppTO(switch (type) {
                case ClientAppType.CASSP -> (ClientApp)this.casSPClientAppDAO.findById(key).orElseThrow();
                case ClientAppType.SAML2SP -> (ClientApp)this.saml2SPClientAppDAO.findById(key).orElseThrow();
                case ClientAppType.OIDCRP -> (ClientApp)this.oidcRPClientAppDAO.findById(key).orElseThrow();
                default -> throw new RuntimeException("Unexpected ClientApp type");
            });
        }
        catch (Throwable t) {
            throw new UnresolvedReferenceException();
        }
    }
}

