/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.InFlightRequests;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InFlightRequestsTest {
    private final String dest = "dest";
    private InFlightRequests inFlightRequests;
    private int correlationId;

    @BeforeEach
    public void setup() {
        this.inFlightRequests = new InFlightRequests(12);
        this.correlationId = 0;
    }

    @Test
    public void testCompleteLastSent() {
        int correlationId1 = this.addRequest("dest");
        int correlationId2 = this.addRequest("dest");
        Assertions.assertEquals((int)2, (int)this.inFlightRequests.count());
        Assertions.assertEquals((int)correlationId2, (int)this.inFlightRequests.completeLastSent((String)"dest").header.correlationId());
        Assertions.assertEquals((int)1, (int)this.inFlightRequests.count());
        Assertions.assertEquals((int)correlationId1, (int)this.inFlightRequests.completeLastSent((String)"dest").header.correlationId());
        Assertions.assertEquals((int)0, (int)this.inFlightRequests.count());
    }

    @Test
    public void testClearAll() {
        int correlationId1 = this.addRequest("dest");
        int correlationId2 = this.addRequest("dest");
        List clearedRequests = TestUtils.toList(this.inFlightRequests.clearAll("dest"));
        Assertions.assertEquals((int)0, (int)this.inFlightRequests.count());
        Assertions.assertEquals((int)2, (int)clearedRequests.size());
        Assertions.assertEquals((int)correlationId1, (int)((NetworkClient.InFlightRequest)clearedRequests.get((int)0)).header.correlationId());
        Assertions.assertEquals((int)correlationId2, (int)((NetworkClient.InFlightRequest)clearedRequests.get((int)1)).header.correlationId());
    }

    @Test
    public void testTimedOutNodes() {
        MockTime time = new MockTime();
        this.addRequest("A", time.milliseconds(), 50);
        this.addRequest("B", time.milliseconds(), 200);
        this.addRequest("B", time.milliseconds(), 100);
        time.sleep(50L);
        Assertions.assertEquals(Collections.emptyList(), (Object)this.inFlightRequests.nodesWithTimedOutRequests(time.milliseconds()));
        time.sleep(25L);
        Assertions.assertEquals(Collections.singletonList("A"), (Object)this.inFlightRequests.nodesWithTimedOutRequests(time.milliseconds()));
        time.sleep(50L);
        Assertions.assertEquals(Arrays.asList("A", "B"), (Object)this.inFlightRequests.nodesWithTimedOutRequests(time.milliseconds()));
    }

    @Test
    public void testCompleteNext() {
        int correlationId1 = this.addRequest("dest");
        int correlationId2 = this.addRequest("dest");
        Assertions.assertEquals((int)2, (int)this.inFlightRequests.count());
        Assertions.assertEquals((int)correlationId1, (int)this.inFlightRequests.completeNext((String)"dest").header.correlationId());
        Assertions.assertEquals((int)1, (int)this.inFlightRequests.count());
        Assertions.assertEquals((int)correlationId2, (int)this.inFlightRequests.completeNext((String)"dest").header.correlationId());
        Assertions.assertEquals((int)0, (int)this.inFlightRequests.count());
    }

    @Test
    public void testCompleteNextThrowsIfNoInflights() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.inFlightRequests.completeNext("dest"));
    }

    @Test
    public void testCompleteLastSentThrowsIfNoInFlights() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.inFlightRequests.completeLastSent("dest"));
    }

    private int addRequest(String destination) {
        return this.addRequest(destination, 0L, 10000);
    }

    private int addRequest(String destination, long sendTimeMs, int requestTimeoutMs) {
        int correlationId = this.correlationId++;
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, 0, "clientId", correlationId);
        NetworkClient.InFlightRequest ifr = new NetworkClient.InFlightRequest(requestHeader, requestTimeoutMs, 0L, destination, null, false, false, null, null, sendTimeMs);
        this.inFlightRequests.add(ifr);
        return correlationId;
    }
}

