/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.agilecoders.wicket.core.util.Dates;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import java.io.IOException;

public abstract class AbstractDateTextFieldConfig<C extends AbstractDateTextFieldConfig, I>
extends AbstractConfig {
    protected static final IKey<String> StartDate = AbstractDateTextFieldConfig.newKey((String)"startDate", null);
    protected static final IKey<String> EndDate = AbstractDateTextFieldConfig.newKey((String)"endDate", null);
    private static final IKey<Integer> StartView = AbstractDateTextFieldConfig.newKey((String)"startView", (Object)0);
    private static final IKey<TodayButton> ShowTodayButton = AbstractDateTextFieldConfig.newKey((String)"todayBtn", (Object)((Object)TodayButton.FALSE));
    private static final IKey<Boolean> KeyboardNavigation = AbstractDateTextFieldConfig.newKey((String)"keyboardNavigation", (Object)true);
    private static final IKey<String> Language = AbstractDateTextFieldConfig.newKey((String)"language", (Object)"en");
    private static final IKey<String> Format = AbstractDateTextFieldConfig.newKey((String)"format", (Object)"mm/dd/yyyy");
    private static final IKey<Integer> WeekStart = AbstractDateTextFieldConfig.newKey((String)"weekStart", (Object)0);
    private static final IKey<Boolean> HighlightToday = AbstractDateTextFieldConfig.newKey((String)"todayHighlight", (Object)false);
    private static final IKey<Boolean> AutoClose = AbstractDateTextFieldConfig.newKey((String)"autoclose", (Object)false);
    private static final IKey<Boolean> ForceParse = AbstractDateTextFieldConfig.newKey((String)"forceParse", (Object)true);
    private static final IKey<Boolean> ClearButton = AbstractDateTextFieldConfig.newKey((String)"clearBtn", (Object)false);
    private static final IKey<Boolean> CalendarWeeks = AbstractDateTextFieldConfig.newKey((String)"calendarWeeks", (Object)false);
    private static final IKey<Integer> MinViewMode = AbstractDateTextFieldConfig.newKey((String)"minViewMode", null);
    private static final IKey<Boolean> Multidate = AbstractDateTextFieldConfig.newKey((String)"multidate", (Object)false);

    public String getFormat() {
        return Dates.toJavaDateFormat((String)this.getString(Format));
    }

    public String getLanguage() {
        return this.getString(Language);
    }

    public boolean isDefaultLanguageSet() {
        return Language.isDefaultValue((Object)this.getLanguage());
    }

    public abstract C withStartDate(I var1);

    public C withMinViewMode(View minViewMode) {
        this.put(MinViewMode, minViewMode.ordinal() + 1);
        return (C)((Object)this);
    }

    public abstract C withEndDate(I var1);

    public C withLanguage(String value) {
        this.put(Language, value);
        return (C)((Object)this);
    }

    public C withView(View value) {
        this.put(StartView, value.ordinal());
        return (C)((Object)this);
    }

    public C withFormat(String value) {
        this.put(Format, Dates.toJavaScriptDateFormat((String)value));
        return (C)((Object)this);
    }

    public C withWeekStart(Day value) {
        this.put(WeekStart, value.ordinal());
        return (C)((Object)this);
    }

    public C allowKeyboardNavigation(boolean value) {
        this.put(KeyboardNavigation, value);
        return (C)((Object)this);
    }

    public C highlightToday(boolean value) {
        this.put(HighlightToday, value);
        return (C)((Object)this);
    }

    public C showTodayButton(TodayButton value) {
        this.put(ShowTodayButton, (Object)value);
        return (C)((Object)this);
    }

    public C forceParse(boolean value) {
        this.put(ForceParse, value);
        return (C)((Object)this);
    }

    public C clearButton(boolean value) {
        this.put(ClearButton, value);
        return (C)((Object)this);
    }

    public C calendarWeeks(boolean value) {
        this.put(CalendarWeeks, value);
        return (C)((Object)this);
    }

    public C autoClose(boolean value) {
        this.put(AutoClose, value);
        return (C)((Object)this);
    }

    public C withMulti(boolean value) {
        this.put(Multidate, value);
        return (C)((Object)this);
    }

    public static enum View {
        Month,
        Year,
        Decade,
        Day;

    }

    public static enum Day {
        Sunday,
        Monday,
        Tuesday,
        Wednesday,
        Thursday,
        Friday,
        Saturday;

    }

    @JsonSerialize(using=TodayButtonSerializer.class)
    public static enum TodayButton {
        TRUE,
        FALSE,
        LINKED;

    }

    private static class TodayButtonSerializer
    extends JsonSerializer<TodayButton> {
        private TodayButtonSerializer() {
        }

        public void serialize(TodayButton value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            switch (value) {
                case TRUE: {
                    jgen.writeBoolean(true);
                    break;
                }
                case FALSE: {
                    jgen.writeBoolean(false);
                    break;
                }
                case LINKED: {
                    jgen.writeString("linked");
                }
            }
        }
    }
}

