/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import com.yammer.metrics.core.Gauge;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.Logger;

public class RemoteStorageThreadPool
extends ThreadPoolExecutor {
    private final Logger logger;
    private final KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup(this.getClass());

    public RemoteStorageThreadPool(String threadNamePrefix, int numThreads, int maxPendingTasks) {
        super(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxPendingTasks), new RemoteStorageThreadFactory(threadNamePrefix));
        this.logger = new LogContext(){

            public String logPrefix() {
                return "[" + Thread.currentThread().getName() + "]";
            }
        }.logger(RemoteStorageThreadPool.class);
        this.metricsGroup.newGauge(RemoteStorageMetrics.REMOTE_LOG_READER_TASK_QUEUE_SIZE_METRIC.getName(), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return RemoteStorageThreadPool.this.getQueue().size();
            }
        });
        this.metricsGroup.newGauge(RemoteStorageMetrics.REMOTE_LOG_READER_AVG_IDLE_PERCENT_METRIC.getName(), (Gauge)new Gauge<Double>(){

            public Double value() {
                return 1.0 - (double)RemoteStorageThreadPool.this.getActiveCount() / (double)RemoteStorageThreadPool.this.getCorePoolSize();
            }
        });
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable th) {
        if (th != null) {
            if (th instanceof FatalExitError) {
                this.logger.error("Stopping the server as it encountered a fatal error.");
                Exit.exit((int)((FatalExitError)th).statusCode());
            } else if (!this.isShutdown()) {
                this.logger.error("Error occurred while executing task: {}", (Object)runnable, (Object)th);
            }
        }
    }

    public void removeMetrics() {
        RemoteStorageMetrics.REMOTE_STORAGE_THREAD_POOL_METRICS.forEach(arg_0 -> ((KafkaMetricsGroup)this.metricsGroup).removeMetric(arg_0));
    }

    private static class RemoteStorageThreadFactory
    implements ThreadFactory {
        private final String namePrefix;
        private final AtomicInteger threadNumber = new AtomicInteger(0);

        RemoteStorageThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
        }
    }
}

