/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.metadata;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.javadoc.Javadoc;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.support.RelaxedPropertyNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;

public class ConfigurationMetadataPropertyCreator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationMetadataPropertyCreator.class);
    private static final Map<String, String> PRIMITIVES = Map.of(String.class.getSimpleName(), String.class.getName(), Integer.class.getSimpleName(), Integer.class.getName(), Boolean.class.getSimpleName(), Boolean.class.getName(), Long.class.getSimpleName(), Long.class.getName(), Double.class.getSimpleName(), Double.class.getName(), Float.class.getSimpleName(), Float.class.getName());
    private final boolean indexNameWithBrackets;
    private final Set<ConfigurationMetadataProperty> properties;
    private final Set<ConfigurationMetadataProperty> groups;
    private final String parentClass;

    public static StringBuilder collectJavadocsEnumFields(ConfigurationMetadataProperty prop, EnumDeclaration em) {
        StringBuilder builder = new StringBuilder(StringUtils.defaultString((String)prop.getDescription()));
        builder.append("\nAvailable values are as follows:\n");
        builder.append("<ul>");
        em.getEntries().stream().filter(entry -> entry.getJavadoc().isPresent()).forEach(entry -> {
            String text = ((Javadoc)entry.getJavadoc().get()).getDescription().toText();
            text = StringUtils.appendIfMissing((String)text, (CharSequence)".", (CharSequence[])new CharSequence[0]);
            String member = String.format("<li>{@code %s}: %s</li>", entry.getNameAsString(), text);
            builder.append(member);
        });
        builder.append("</ul>");
        return builder;
    }

    public ConfigurationMetadataProperty createConfigurationProperty(FieldDeclaration fieldDecl, String propName) {
        VariableDeclarator variable = (VariableDeclarator)fieldDecl.getVariables().getFirst().orElseThrow();
        String name = StreamSupport.stream(RelaxedPropertyNames.forCamelCase(variable.getNameAsString()).spliterator(), false).map(Object::toString).findFirst().orElseGet(() -> ((VariableDeclarator)variable).getNameAsString());
        String indexedGroup = propName.concat(this.indexNameWithBrackets ? "[]" : "");
        String indexedName = indexedGroup.concat(".").concat(name);
        ConfigurationMetadataProperty prop = new ConfigurationMetadataProperty();
        if (fieldDecl.getJavadoc().isPresent()) {
            Optional<ConfigurationMetadataProperty> groupProperty;
            Object description = "";
            if (indexedName.endsWith(".location") && (groupProperty = this.properties.stream().filter(p -> p.getName().equalsIgnoreCase(indexedGroup)).findFirst()).isPresent()) {
                description = groupProperty.get().getDescription() + "\n";
            }
            description = (String)description + ((Javadoc)fieldDecl.getJavadoc().get()).getDescription().toText();
            prop.setDescription((String)description);
            prop.setShortDescription(StringUtils.substringBefore((String)description, (String)"."));
        } else {
            LOGGER.error("No Javadoc found for field [{}]", (Object)indexedName);
        }
        prop.setName(indexedName);
        prop.setId(indexedName);
        Type elementType = fieldDecl.getElementType();
        String elementTypeStr = elementType.asString();
        if (PRIMITIVES.containsKey(elementTypeStr)) {
            prop.setType(PRIMITIVES.get(elementTypeStr));
        } else if (elementTypeStr.startsWith("Map<") || elementTypeStr.startsWith("List<") || elementTypeStr.startsWith("Set<")) {
            prop.setType("java.util." + elementTypeStr);
            String typeName = elementTypeStr.substring(elementTypeStr.indexOf(60) + 1, elementTypeStr.indexOf(62));
            Node parent = (Node)fieldDecl.getParentNode().orElseThrow();
            parent.findFirst(EnumDeclaration.class, em -> em.getNameAsString().contains(typeName)).ifPresent(em -> {
                StringBuilder builder = ConfigurationMetadataPropertyCreator.collectJavadocsEnumFields(prop, em);
                prop.setDescription(builder.toString());
            });
        } else {
            prop.setType(elementTypeStr);
            Node parent = (Node)fieldDecl.getParentNode().orElseThrow();
            Optional enumDecl = parent.findFirst(EnumDeclaration.class, em -> em.getNameAsString().contains(elementTypeStr));
            if (enumDecl.isPresent()) {
                EnumDeclaration em2 = (EnumDeclaration)enumDecl.get();
                StringBuilder builder = ConfigurationMetadataPropertyCreator.collectJavadocsEnumFields(prop, em2);
                prop.setDescription(builder.toString());
                em2.getFullyQualifiedName().ifPresent(arg_0 -> ((ConfigurationMetadataProperty)prop).setType(arg_0));
            }
        }
        Optional initializer = variable.getInitializer();
        if (initializer.isPresent()) {
            Expression exp = (Expression)initializer.get();
            try {
                Class<?> parentClassInstance = Class.forName(this.parentClass);
                if (!Modifier.isAbstract(parentClassInstance.getModifiers())) {
                    Object classInstance = parentClassInstance.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Field propertyField = parentClassInstance.getDeclaredField(variable.getNameAsString());
                    propertyField.trySetAccessible();
                    Object resultingValue = propertyField.get(classInstance);
                    Class<?> valueType = resultingValue.getClass();
                    if (valueType.isArray()) {
                        prop.setDefaultValue((Object)Arrays.toString((Object[])resultingValue));
                    } else if (resultingValue instanceof Collection) {
                        Collection results = (Collection)resultingValue;
                        if (!results.isEmpty()) {
                            String values = results.stream().map(Object::toString).collect(Collectors.joining(","));
                            prop.setDefaultValue((Object)values);
                        }
                    } else if (valueType.isPrimitive() || valueType.isEnum() || PRIMITIVES.containsKey(valueType.getSimpleName()) || PRIMITIVES.containsKey(elementTypeStr)) {
                        prop.setDefaultValue((Object)resultingValue.toString());
                    } else if (resultingValue instanceof Map) {
                        Map mappedValue = (Map)resultingValue;
                        if (!mappedValue.isEmpty()) {
                            LOGGER.warn("Found configuration property as a Map: [{}]:[{}] with values [{}]", new Object[]{variable.getNameAsString(), valueType.getName(), mappedValue});
                        }
                    } else if (!this.parentClass.endsWith("Properties")) {
                        LOGGER.debug("Cannot determine default value; Unknown configuration property type [{}]:[{}]", (Object)variable.getNameAsString(), (Object)valueType.getName());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Processing [{}]:[{}]. Error [{}]", new Object[]{this.parentClass, name, e});
                Expression expression = exp;
                Objects.requireNonNull(expression);
                Expression expression2 = expression;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LiteralStringValueExpr.class, BooleanLiteralExpr.class, FieldAccessExpr.class}, (Object)expression2, n)) {
                    case 0: {
                        LiteralStringValueExpr ex = (LiteralStringValueExpr)expression2;
                        prop.setDefaultValue((Object)ex.getValue());
                        break;
                    }
                    case 1: {
                        BooleanLiteralExpr ex = (BooleanLiteralExpr)expression2;
                        prop.setDefaultValue((Object)ex.getValue());
                        break;
                    }
                    case 2: {
                        FieldAccessExpr ex = (FieldAccessExpr)expression2;
                        prop.setDefaultValue((Object)ex.getNameAsString());
                        break;
                    }
                }
            }
        }
        LOGGER.debug("Collecting property [{}]", (Object)prop.getName());
        this.properties.add(prop);
        ComparableConfigurationMetadataProperty grp = new ComparableConfigurationMetadataProperty();
        grp.setId(indexedGroup);
        grp.setName(indexedGroup);
        grp.setType(this.parentClass);
        LOGGER.debug("Collecting property [{}]", (Object)grp.getName());
        this.groups.add(grp);
        return prop;
    }

    @Generated
    public ConfigurationMetadataPropertyCreator(boolean indexNameWithBrackets, Set<ConfigurationMetadataProperty> properties, Set<ConfigurationMetadataProperty> groups, String parentClass) {
        this.indexNameWithBrackets = indexNameWithBrackets;
        this.properties = properties;
        this.groups = groups;
        this.parentClass = parentClass;
    }

    static final class ComparableConfigurationMetadataProperty
    extends ConfigurationMetadataProperty {
        private static final long serialVersionUID = -7924691650447203471L;

        ComparableConfigurationMetadataProperty() {
        }

        public int hashCode() {
            return Objects.hash(this.getId());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConfigurationMetadataProperty) {
                ConfigurationMetadataProperty rhs = (ConfigurationMetadataProperty)obj;
                return Objects.equals(this.getId(), rhs.getId());
            }
            return false;
        }
    }
}

