/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.resultset.filter;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.filter.FilteringIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DeduplicatingIterator<O, A>
extends FilteringIterator<O> {
    private final Attribute<O, A> uniqueAttribute;
    private final Set<A> attributeValuesProcessed = new HashSet<A>();

    public DeduplicatingIterator(Attribute<O, A> uniqueAttribute, QueryOptions queryOptions, Iterator<O> wrappedIterator) {
        super(wrappedIterator, queryOptions);
        this.uniqueAttribute = uniqueAttribute;
    }

    @Override
    public boolean isValid(O object, QueryOptions queryOptions) {
        boolean modified = false;
        for (A value : this.uniqueAttribute.getValues(object, queryOptions)) {
            modified = this.attributeValuesProcessed.add(value) || modified;
        }
        return modified;
    }
}

