/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Exec;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.persistence.jpa.entity.task.AbstractTaskExec;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class JPATaskExecDAO
implements TaskExecDAO {
    protected final TaskDAO taskDAO;
    protected final TaskUtilsFactory taskUtilsFactory;
    protected final EntityManager entityManager;

    public JPATaskExecDAO(TaskDAO taskDAO, TaskUtilsFactory taskUtilsFactory, EntityManager entityManager) {
        this.taskDAO = taskDAO;
        this.taskUtilsFactory = taskUtilsFactory;
        this.entityManager = entityManager;
    }

    public boolean existsById(String key) {
        return this.findById(key).isPresent();
    }

    public <T extends Task<T>> Optional<TaskExec<T>> findById(TaskType type, String key) {
        return Optional.ofNullable((TaskExec)this.entityManager.find(this.taskUtilsFactory.getInstance(type).getTaskExecEntity(), (Object)key));
    }

    public Optional<? extends TaskExec<?>> findById(String key) {
        Optional task = this.findById(TaskType.SCHEDULED, key);
        if (task.isEmpty()) {
            task = this.findById(TaskType.PULL, key);
        }
        if (task.isEmpty()) {
            task = this.findById(TaskType.PUSH, key);
        }
        if (task.isEmpty()) {
            task = this.findById(TaskType.MACRO, key);
        }
        if (task.isEmpty()) {
            task = this.findById(TaskType.PROPAGATION, key);
        }
        if (task.isEmpty()) {
            task = this.findById(TaskType.NOTIFICATION, key);
        }
        return task;
    }

    protected <T extends Task<T>> List<TaskExec<T>> findRecent(TaskType type, int max) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + this.taskUtilsFactory.getInstance(type).getTaskExecEntity().getSimpleName() + " e WHERE e.end IS NOT NULL ORDER BY e.end DESC");
        query.setMaxResults(max);
        List result = query.getResultList();
        return result.stream().map(e -> (TaskExec)e).toList();
    }

    public List<TaskExec<?>> findRecent(int max) {
        ArrayList recent = new ArrayList();
        for (TaskType taskType : TaskType.values()) {
            recent.addAll(this.findRecent(taskType, max));
        }
        return recent.stream().sorted(Comparator.comparing(Exec::getEnd).reversed()).limit(max).toList();
    }

    protected Optional<? extends TaskExec<?>> findLatest(TaskType type, Task<?> task, String field) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + this.taskUtilsFactory.getInstance(type).getTaskExecEntity().getSimpleName() + " e WHERE e.task.id=:task ORDER BY e." + field + " DESC");
        query.setParameter("task", (Object)task.getKey());
        query.setMaxResults(1);
        List result = query.getResultList();
        return CollectionUtils.isEmpty((Collection)result) ? Optional.empty() : Optional.of((TaskExec)result.getFirst());
    }

    public Optional<? extends TaskExec<?>> findLatestStarted(TaskType type, Task<?> task) {
        return this.findLatest(type, task, "start");
    }

    public Optional<? extends TaskExec<?>> findLatestEnded(TaskType type, Task<?> task) {
        return this.findLatest(type, task, "end");
    }

    public long count() {
        throw new UnsupportedOperationException();
    }

    protected StringBuilder query(StringBuilder select, Task<?> task, OffsetDateTime before, OffsetDateTime after) {
        StringBuilder query = select.append(this.taskUtilsFactory.getInstance(task).getTaskExecEntity().getSimpleName()).append(" e WHERE e.task=:task ");
        if (before != null) {
            query.append("AND e.start <= :before ");
        }
        if (after != null) {
            query.append("AND e.start >= :after ");
        }
        return query;
    }

    public long count(Task<?> task, OffsetDateTime before, OffsetDateTime after) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT COUNT(e) FROM "), task, before, after);
        Query query = this.entityManager.createQuery(queryString.toString());
        query.setParameter("task", task);
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        return ((Number)query.getSingleResult()).longValue();
    }

    protected String toOrderByStatement(Stream<Sort.Order> orderByClauses) {
        StringBuilder statement = new StringBuilder();
        orderByClauses.forEach(clause -> {
            String field = clause.getProperty().trim();
            if (ReflectionUtils.findField(AbstractTaskExec.class, (String)field) != null) {
                statement.append("e.").append(field).append(' ').append(clause.getDirection().name());
            }
        });
        if (statement.length() == 0) {
            statement.append(" ORDER BY e.id DESC");
        } else {
            statement.insert(0, " ORDER BY ");
        }
        return statement.toString();
    }

    public List<? extends TaskExec<?>> findAll() {
        throw new UnsupportedOperationException();
    }

    public List<TaskExec<?>> findAll(Task<?> task, OffsetDateTime before, OffsetDateTime after, Pageable pageable) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT e FROM "), task, before, after).append(this.toOrderByStatement(pageable.getSort().stream()));
        Query query = this.entityManager.createQuery(queryString.toString());
        query.setParameter("task", task);
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        if (pageable.isPaged()) {
            query.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
            query.setMaxResults(pageable.getPageSize());
        }
        List result = query.getResultList();
        return result.stream().map(e -> (TaskExec)e).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Throwable.class})
    public <S extends TaskExec<?>> S save(S execution) {
        return (S)((TaskExec)this.entityManager.merge(execution));
    }

    @Transactional(rollbackFor={Throwable.class})
    public <T extends Task<T>> void saveAndAdd(TaskType taskType, String taskKey, TaskExec<T> execution) {
        Optional task = this.taskDAO.findById(taskType, taskKey);
        if (task.isPresent()) {
            ((Task)task.get()).add(execution);
            this.taskDAO.save((Entity)((Task)task.get()));
        }
    }

    public <T extends Task<T>> void delete(TaskType taskType, String key) {
        this.findById(taskType, key).ifPresent(this::delete);
    }

    public void delete(TaskExec<?> execution) {
        Optional.ofNullable(execution.getTask()).ifPresent(task -> task.getExecs().remove(execution));
        this.entityManager.remove(execution);
    }

    public void deleteById(String key) {
        this.findById(key).ifPresent(this::delete);
    }
}

