/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.clients;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jBaseClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCoreProperties;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviderFactory;
import org.apereo.cas.support.pac4j.authentication.clients.ConfigurableDelegatedClient;
import org.apereo.cas.support.pac4j.authentication.clients.ConfigurableDelegatedClientBuilder;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.concurrent.CasReentrantLock;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.core.http.callback.PathParameterCallbackUrlResolver;
import org.pac4j.core.http.callback.QueryParameterCallbackUrlResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public abstract class BaseDelegatedIdentityProviderFactory
implements DelegatedIdentityProviderFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDelegatedIdentityProviderFactory.class);
    protected final CasConfigurationProperties casProperties;
    protected final Collection<DelegatedClientFactoryCustomizer> customizers;
    protected final CasSSLContext casSSLContext;
    protected final Cache<String, Collection<BaseClient>> clientsCache;
    protected final ConfigurableApplicationContext applicationContext;
    private final CasReentrantLock lock = new CasReentrantLock();

    protected abstract Collection<BaseClient> loadIdentityProviders() throws Exception;

    public final Collection<BaseClient> build() {
        return (Collection)this.lock.tryLock(() -> {
            Pac4jDelegatedAuthenticationCoreProperties core = this.casProperties.getAuthn().getPac4j().getCore();
            Collection<BaseClient> currentClients = this.getCachedClients().isEmpty() || !core.isLazyInit() ? this.loadIdentityProviders() : this.getCachedClients();
            this.clientsCache.put((Object)this.casProperties.getServer().getName(), currentClients);
            return currentClients;
        });
    }

    public Collection<BaseClient> rebuild() {
        this.clientsCache.invalidateAll();
        return this.build();
    }

    protected Collection<BaseClient> getCachedClients() {
        Collection cachedClients = (Collection)this.clientsCache.getIfPresent((Object)this.casProperties.getServer().getName());
        return (Collection)ObjectUtils.defaultIfNull((Object)cachedClients, new ArrayList());
    }

    protected BaseClient configureClient(BaseClient client, Pac4jBaseClientProperties clientProperties, CasConfigurationProperties givenProperties) {
        if (clientProperties != null) {
            String cname = clientProperties.getClientName();
            if (StringUtils.isNotBlank((CharSequence)cname)) {
                client.setName(cname);
            } else {
                String className = client.getClass().getSimpleName();
                String genName = className.concat(RandomUtils.randomNumeric((int)4));
                client.setName(genName);
                LOGGER.warn("Client name for [{}] is set to a generated value of [{}]. Consider defining an explicit name for the delegated provider", (Object)className, (Object)genName);
            }
            Map customProperties = client.getCustomProperties();
            customProperties.put("autoRedirectType", clientProperties.getAutoRedirectType());
            FunctionUtils.doIfNotBlank((CharSequence)clientProperties.getPrincipalIdAttribute(), __ -> customProperties.put("principalAttributeId", clientProperties.getPrincipalIdAttribute()));
            FunctionUtils.doIfNotBlank((CharSequence)clientProperties.getCssClass(), __ -> customProperties.put("cssClass", clientProperties.getCssClass()));
            FunctionUtils.doIfNotBlank((CharSequence)clientProperties.getDisplayName(), __ -> customProperties.put("displayName", clientProperties.getDisplayName()));
            if (client instanceof IndirectClient) {
                IndirectClient indirectClient = (IndirectClient)client;
                String callbackUrl = (String)StringUtils.defaultIfBlank((CharSequence)clientProperties.getCallbackUrl(), (CharSequence)this.casProperties.getServer().getLoginUrl());
                indirectClient.setCallbackUrl(callbackUrl);
                LOGGER.trace("Client [{}] will use the callback URL [{}]", (Object)client.getName(), (Object)callbackUrl);
                PathParameterCallbackUrlResolver resolver = switch (clientProperties.getCallbackUrlType()) {
                    default -> throw new MatchException(null, null);
                    case Pac4jBaseClientProperties.CallbackUrlTypes.PATH_PARAMETER -> new PathParameterCallbackUrlResolver();
                    case Pac4jBaseClientProperties.CallbackUrlTypes.NONE -> new NoParameterCallbackUrlResolver();
                    case Pac4jBaseClientProperties.CallbackUrlTypes.QUERY_PARAMETER -> new QueryParameterCallbackUrlResolver();
                };
                indirectClient.setCallbackUrlResolver((CallbackUrlResolver)resolver);
            }
        }
        this.customizers.forEach(customizer -> customizer.customize(client));
        if (!givenProperties.getAuthn().getPac4j().getCore().isLazyInit()) {
            client.init();
        }
        LOGGER.debug("Configured external identity provider [{}]", (Object)client.getName());
        return client;
    }

    protected Set<BaseClient> buildAllIdentityProviders(CasConfigurationProperties properties) throws Exception {
        LinkedHashSet<BaseClient> newClients = new LinkedHashSet<BaseClient>();
        List<ConfigurableDelegatedClientBuilder> builders = this.getDelegatedClientBuilders();
        for (ConfigurableDelegatedClientBuilder builder : builders) {
            List<ConfigurableDelegatedClient> builtClients = builder.build(properties);
            LOGGER.debug("Builder [{}] provides [{}] clients", (Object)builder.getName(), (Object)builtClients.size());
            builtClients.forEach(instance -> {
                BaseClient preparedClient = this.configureClient(instance.getClient(), instance.getProperties(), properties);
                newClients.add(builder.configure(preparedClient, instance.getProperties(), properties));
            });
        }
        return newClients;
    }

    private List<ConfigurableDelegatedClientBuilder> getDelegatedClientBuilders() {
        ArrayList<ConfigurableDelegatedClientBuilder> builders = new ArrayList<ConfigurableDelegatedClientBuilder>(this.applicationContext.getBeansOfType(ConfigurableDelegatedClientBuilder.class).values());
        AnnotationAwareOrderComparator.sort(builders);
        return builders;
    }

    @Generated
    public BaseDelegatedIdentityProviderFactory(CasConfigurationProperties casProperties, Collection<DelegatedClientFactoryCustomizer> customizers, CasSSLContext casSSLContext, Cache<String, Collection<BaseClient>> clientsCache, ConfigurableApplicationContext applicationContext) {
        this.casProperties = casProperties;
        this.customizers = customizers;
        this.casSSLContext = casSSLContext;
        this.clientsCache = clientsCache;
        this.applicationContext = applicationContext;
    }
}

