/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.impl.util;

import java.util.Collections;
import java.util.Map;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.ValidatorSettings;
import org.jetbrains.annotations.NotNull;

public class ValidatorSettingsImpl
implements ValidatorSettings {
    private final boolean isDisabled;
    private final ValidationMessageSeverity defaultSeverity;
    private final Map<String, String> options;

    public ValidatorSettingsImpl(boolean isDisabled) {
        this(isDisabled, null, null);
    }

    public ValidatorSettingsImpl() {
        this(false, null, null);
    }

    public ValidatorSettingsImpl(ValidationMessageSeverity defaultSeverity) {
        this(false, defaultSeverity, null);
    }

    public ValidatorSettingsImpl(String optionKey, String optionValue) {
        this(false, null, Collections.singletonMap(optionKey, optionValue));
    }

    public ValidatorSettingsImpl(boolean isDisabled, ValidationMessageSeverity defaultSeverity, Map<String, String> options) {
        this.isDisabled = isDisabled;
        this.defaultSeverity = defaultSeverity;
        this.options = options;
    }

    @Override
    @NotNull
    public ValidationMessageSeverity getDefaultSeverity() {
        if (this.defaultSeverity == null) {
            return ValidationMessageSeverity.ERROR;
        }
        return this.defaultSeverity;
    }

    @Override
    @NotNull
    public Map<String, String> getOptions() {
        if (this.options == null) {
            return Collections.emptyMap();
        }
        return this.options;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }
}

