/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader;

import java.util.Arrays;
import javax.jcr.Value;
import org.jetbrains.annotations.NotNull;

public class LocalRestriction {
    private String restriction;
    private boolean multival;
    private Value[] values;

    public LocalRestriction(@NotNull String restriction, Value[] values) {
        this.restriction = restriction;
        this.multival = true;
        this.values = values;
    }

    public LocalRestriction(@NotNull String restriction, Value value) {
        Value[] valueArray;
        this.restriction = restriction;
        this.multival = false;
        if (value == null) {
            valueArray = null;
        } else {
            Value[] valueArray2 = new Value[1];
            valueArray = valueArray2;
            valueArray2[0] = value;
        }
        this.values = valueArray;
    }

    public String getName() {
        return this.restriction;
    }

    public boolean isMultiValue() {
        return this.multival;
    }

    public Value getValue() {
        Value v = null;
        if (this.values != null && this.values.length > 0) {
            v = this.values[0];
        }
        return v;
    }

    public Value[] getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalRestriction [restriction=");
        builder.append(this.restriction);
        builder.append(", multival=");
        builder.append(this.multival);
        builder.append(", values=");
        builder.append(Arrays.toString(this.values));
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.multival ? 1231 : 1237);
        result = 31 * result + (this.restriction == null ? 0 : this.restriction.hashCode());
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalRestriction other = (LocalRestriction)obj;
        if (this.multival != other.multival) {
            return false;
        }
        if (this.restriction == null ? other.restriction != null : !this.restriction.equals(other.restriction)) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }
}

