/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConfigLoader;
import org.openapitools.codegen.SpecValidationException;
import org.openapitools.codegen.TemplatingEngineLoader;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.auth.AuthParser;
import org.openapitools.codegen.config.Context;
import org.openapitools.codegen.config.DynamicSettings;
import org.openapitools.codegen.config.GeneratorSettings;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.config.WorkflowSettings;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodegenConfigurator {
    public static final Logger LOGGER = LoggerFactory.getLogger(CodegenConfigurator.class);
    private GeneratorSettings.Builder generatorSettingsBuilder = GeneratorSettings.newBuilder();
    private WorkflowSettings.Builder workflowSettingsBuilder = WorkflowSettings.newBuilder();
    private String generatorName;
    private String inputSpec;
    private String templatingEngineName;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private Map<String, String> instantiationTypes = new HashMap<String, String>();
    private Map<String, String> typeMappings = new HashMap<String, String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private Map<String, String> importMappings = new HashMap<String, String>();
    private Set<String> languageSpecificPrimitives = new HashSet<String>();
    private Map<String, String> reservedWordMappings = new HashMap<String, String>();
    private Map<String, String> serverVariables = new HashMap<String, String>();
    private String auth;

    public static CodegenConfigurator fromFile(String configFile) {
        if (StringUtils.isNotEmpty((CharSequence)configFile)) {
            ObjectMapper mapper = FilenameUtils.isExtension((String)configFile, (String[])new String[]{"yml", "yaml"}) ? Yaml.mapper() : Json.mapper();
            mapper.registerModule((Module)new GuavaModule());
            try {
                DynamicSettings settings = (DynamicSettings)mapper.readValue(new File(configFile), DynamicSettings.class);
                CodegenConfigurator configurator = new CodegenConfigurator();
                configurator.generatorSettingsBuilder = GeneratorSettings.newBuilder((GeneratorSettings)settings.getGeneratorSettings());
                configurator.workflowSettingsBuilder = WorkflowSettings.newBuilder((WorkflowSettings)settings.getWorkflowSettings());
                return configurator;
            }
            catch (IOException ex) {
                LOGGER.error("Unable to deserialize config file: " + configFile, (Throwable)ex);
            }
        }
        return null;
    }

    public CodegenConfigurator addServerVariable(String key, String value) {
        this.serverVariables.put(key, value);
        this.generatorSettingsBuilder.withServerVariable(key, value);
        return this;
    }

    public CodegenConfigurator addAdditionalProperty(String key, Object value) {
        this.additionalProperties.put(key, value);
        this.generatorSettingsBuilder.withAdditionalProperty(key, value);
        return this;
    }

    public CodegenConfigurator addAdditionalReservedWordMapping(String key, String value) {
        this.reservedWordMappings.put(key, value);
        this.generatorSettingsBuilder.withReservedWordMapping(key, value);
        return this;
    }

    public CodegenConfigurator addImportMapping(String key, String value) {
        this.importMappings.put(key, value);
        this.generatorSettingsBuilder.withImportMapping(key, value);
        return this;
    }

    public CodegenConfigurator addInstantiationType(String key, String value) {
        this.instantiationTypes.put(key, value);
        this.generatorSettingsBuilder.withInstantiationType(key, value);
        return this;
    }

    public CodegenConfigurator addLanguageSpecificPrimitive(String value) {
        this.languageSpecificPrimitives.add(value);
        this.generatorSettingsBuilder.withLanguageSpecificPrimitive(value);
        return this;
    }

    public CodegenConfigurator addSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
        this.workflowSettingsBuilder.withSystemProperty(key, value);
        return this;
    }

    public CodegenConfigurator addTypeMapping(String key, String value) {
        this.typeMappings.put(key, value);
        this.generatorSettingsBuilder.withTypeMappings(this.typeMappings);
        return this;
    }

    public CodegenConfigurator setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        this.generatorSettingsBuilder.withAdditionalProperties(additionalProperties);
        return this;
    }

    public CodegenConfigurator setServerVariables(Map<String, String> serverVariables) {
        this.serverVariables = serverVariables;
        this.generatorSettingsBuilder.withServerVariables(serverVariables);
        return this;
    }

    public CodegenConfigurator setReservedWordsMappings(Map<String, String> reservedWordMappings) {
        this.reservedWordMappings = reservedWordMappings;
        this.generatorSettingsBuilder.withReservedWordMappings(reservedWordMappings);
        return this;
    }

    public CodegenConfigurator setApiPackage(String apiPackage) {
        this.generatorSettingsBuilder.withApiPackage(apiPackage);
        return this;
    }

    public CodegenConfigurator setArtifactId(String artifactId) {
        this.generatorSettingsBuilder.withArtifactId(artifactId);
        return this;
    }

    public CodegenConfigurator setArtifactVersion(String artifactVersion) {
        this.generatorSettingsBuilder.withArtifactVersion(artifactVersion);
        return this;
    }

    public CodegenConfigurator setAuth(String auth) {
        this.auth = auth;
        return this;
    }

    public CodegenConfigurator setEnableMinimalUpdate(boolean enableMinimalUpdate) {
        this.workflowSettingsBuilder.withEnableMinimalUpdate(Boolean.valueOf(enableMinimalUpdate));
        return this;
    }

    public CodegenConfigurator setEnablePostProcessFile(boolean enablePostProcessFile) {
        this.workflowSettingsBuilder.withEnablePostProcessFile(Boolean.valueOf(enablePostProcessFile));
        return this;
    }

    public CodegenConfigurator setGenerateAliasAsModel(boolean generateAliasAsModel) {
        ModelUtils.setGenerateAliasAsModel(generateAliasAsModel);
        return this;
    }

    public CodegenConfigurator setGeneratorName(String generatorName) {
        this.generatorName = generatorName;
        this.generatorSettingsBuilder.withGeneratorName(generatorName);
        return this;
    }

    public CodegenConfigurator setGitRepoId(String gitRepoId) {
        this.generatorSettingsBuilder.withGitRepoId(gitRepoId);
        return this;
    }

    public CodegenConfigurator setGitHost(String gitHost) {
        this.generatorSettingsBuilder.withGitHost(gitHost);
        return this;
    }

    public CodegenConfigurator setGitUserId(String gitUserId) {
        this.generatorSettingsBuilder.withGitUserId(gitUserId);
        return this;
    }

    public CodegenConfigurator setGroupId(String groupId) {
        this.generatorSettingsBuilder.withGroupId(groupId);
        return this;
    }

    public CodegenConfigurator setHttpUserAgent(String httpUserAgent) {
        this.generatorSettingsBuilder.withHttpUserAgent(httpUserAgent);
        return this;
    }

    public CodegenConfigurator setIgnoreFileOverride(String ignoreFileOverride) {
        this.workflowSettingsBuilder.withIgnoreFileOverride(ignoreFileOverride);
        return this;
    }

    public CodegenConfigurator setImportMappings(Map<String, String> importMappings) {
        this.importMappings = importMappings;
        this.generatorSettingsBuilder.withImportMappings(importMappings);
        return this;
    }

    public CodegenConfigurator setInputSpec(String inputSpec) {
        this.inputSpec = inputSpec;
        this.workflowSettingsBuilder.withInputSpec(inputSpec);
        return this;
    }

    public CodegenConfigurator setInstantiationTypes(Map<String, String> instantiationTypes) {
        this.instantiationTypes = instantiationTypes;
        this.generatorSettingsBuilder.withInstantiationTypes(instantiationTypes);
        return this;
    }

    public CodegenConfigurator setInvokerPackage(String invokerPackage) {
        this.generatorSettingsBuilder.withInvokerPackage(invokerPackage);
        return this;
    }

    public CodegenConfigurator setLanguageSpecificPrimitives(Set<String> languageSpecificPrimitives) {
        this.languageSpecificPrimitives = languageSpecificPrimitives;
        this.generatorSettingsBuilder.withLanguageSpecificPrimitives(languageSpecificPrimitives);
        return this;
    }

    public CodegenConfigurator setLibrary(String library) {
        this.generatorSettingsBuilder.withLibrary(library);
        return this;
    }

    public CodegenConfigurator setLogToStderr(boolean logToStderr) {
        this.workflowSettingsBuilder.withLogToStderr(Boolean.valueOf(logToStderr));
        return this;
    }

    public CodegenConfigurator setModelNamePrefix(String prefix) {
        this.generatorSettingsBuilder.withModelNamePrefix(prefix);
        return this;
    }

    public CodegenConfigurator setModelNameSuffix(String suffix) {
        this.generatorSettingsBuilder.withModelNameSuffix(suffix);
        return this;
    }

    public CodegenConfigurator setModelPackage(String modelPackage) {
        this.generatorSettingsBuilder.withModelPackage(modelPackage);
        return this;
    }

    public CodegenConfigurator setOutputDir(String outputDir) {
        this.workflowSettingsBuilder.withOutputDir(outputDir);
        return this;
    }

    public CodegenConfigurator setPackageName(String packageName) {
        this.generatorSettingsBuilder.withPackageName(packageName);
        return this;
    }

    public CodegenConfigurator setReleaseNote(String releaseNote) {
        this.generatorSettingsBuilder.withReleaseNote(releaseNote);
        return this;
    }

    public CodegenConfigurator setRemoveOperationIdPrefix(boolean removeOperationIdPrefix) {
        this.workflowSettingsBuilder.withRemoveOperationIdPrefix(Boolean.valueOf(removeOperationIdPrefix));
        return this;
    }

    public CodegenConfigurator setSkipOverwrite(boolean skipOverwrite) {
        this.workflowSettingsBuilder.withSkipOverwrite(Boolean.valueOf(skipOverwrite));
        return this;
    }

    public CodegenConfigurator setStrictSpecBehavior(boolean strictSpecBehavior) {
        this.workflowSettingsBuilder.withStrictSpecBehavior(Boolean.valueOf(strictSpecBehavior));
        return this;
    }

    public CodegenConfigurator setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
        this.workflowSettingsBuilder.withSystemProperties(systemProperties);
        return this;
    }

    public CodegenConfigurator setTemplateDir(String templateDir) {
        this.workflowSettingsBuilder.withTemplateDir(templateDir);
        return this;
    }

    public CodegenConfigurator setTemplatingEngineName(String templatingEngineName) {
        this.templatingEngineName = templatingEngineName;
        this.workflowSettingsBuilder.withTemplatingEngineName(templatingEngineName);
        return this;
    }

    public CodegenConfigurator setTypeMappings(Map<String, String> typeMappings) {
        this.typeMappings = typeMappings;
        this.generatorSettingsBuilder.withTypeMappings(typeMappings);
        return this;
    }

    public CodegenConfigurator setValidateSpec(boolean validateSpec) {
        this.workflowSettingsBuilder.withValidateSpec(Boolean.valueOf(validateSpec));
        return this;
    }

    public CodegenConfigurator setVerbose(boolean verbose) {
        this.workflowSettingsBuilder.withVerbose(Boolean.valueOf(verbose));
        return this;
    }

    public Context<?> toContext() {
        Validate.notEmpty((CharSequence)this.generatorName, (String)"language/generatorName must be specified", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)this.inputSpec, (String)"input spec must be specified", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)this.templatingEngineName)) {
            this.workflowSettingsBuilder.withTemplatingEngineName("mustache");
        } else {
            this.workflowSettingsBuilder.withTemplatingEngineName(this.templatingEngineName);
        }
        GeneratorSettings generatorSettings = this.generatorSettingsBuilder.build();
        WorkflowSettings workflowSettings = this.workflowSettingsBuilder.build();
        if (workflowSettings.isVerbose()) {
            LOGGER.info("\nVERBOSE MODE: ON. Additional debug options are injected\n - [debugOpenAPI] prints the OpenAPI specification as interpreted by the codegen\n - [debugModels] prints models passed to the template engine\n - [debugOperations] prints operations passed to the template engine\n - [debugSupportingFiles] prints additional data passed to the template engine");
            GlobalSettings.setProperty("debugOpenAPI", "");
            GlobalSettings.setProperty("debugModels", "");
            GlobalSettings.setProperty("debugOperations", "");
            GlobalSettings.setProperty("debugSupportingFiles", "");
        }
        for (Map.Entry entry : workflowSettings.getSystemProperties().entrySet()) {
            GlobalSettings.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        List<AuthorizationValue> authorizationValues = AuthParser.parse(this.auth);
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        SwaggerParseResult result = new OpenAPIParser().readLocation(this.inputSpec, authorizationValues, options);
        HashSet<String> validationMessages = new HashSet<String>(result.getMessages());
        OpenAPI specification = result.getOpenAPI();
        if (validationMessages.size() > 0) {
            CharSequence sb;
            List<String> unusedModels;
            HashSet<String> warnings = new HashSet<String>();
            if (specification != null && (unusedModels = ModelUtils.getUnusedSchemas(specification)) != null) {
                unusedModels.forEach(name -> warnings.add("Unused model: " + name));
            }
            if (workflowSettings.isValidateSpec()) {
                sb = "There were issues with the specification. The option can be disabled via validateSpec (Maven/Gradle) or --skip-validate-spec (CLI)." + System.lineSeparator();
                SpecValidationException ex = new SpecValidationException((String)sb);
                ex.setErrors(validationMessages);
                ex.setWarnings(warnings);
                throw ex;
            }
            sb = new StringBuilder();
            ((StringBuilder)sb).append("There were issues with the specification, but validation has been explicitly disabled.");
            ((StringBuilder)sb).append(System.lineSeparator());
            ((StringBuilder)sb).append("Errors: ").append(System.lineSeparator());
            validationMessages.forEach(arg_0 -> CodegenConfigurator.lambda$toContext$1((StringBuilder)sb, arg_0));
            if (!warnings.isEmpty()) {
                ((StringBuilder)sb).append("Warnings: ").append(System.lineSeparator());
                warnings.forEach(arg_0 -> CodegenConfigurator.lambda$toContext$2((StringBuilder)sb, arg_0));
            }
            LOGGER.warn(((StringBuilder)sb).toString());
        }
        return new Context((Object)specification, generatorSettings, workflowSettings);
    }

    public ClientOptInput toClientOptInput() {
        String templateDir;
        CodegenConfig config = CodegenConfigLoader.forName(this.generatorName);
        Context<?> context = this.toContext();
        WorkflowSettings workflowSettings = context.getWorkflowSettings();
        GeneratorSettings generatorSettings = context.getGeneratorSettings();
        if (StringUtils.isNotEmpty((CharSequence)generatorSettings.getLibrary())) {
            config.setLibrary(generatorSettings.getLibrary());
        }
        config.setInputSpec(workflowSettings.getInputSpec());
        config.setOutputDir(workflowSettings.getOutputDir());
        config.setSkipOverwrite(workflowSettings.isSkipOverwrite());
        config.setIgnoreFilePathOverride(workflowSettings.getIgnoreFileOverride());
        config.setRemoveOperationIdPrefix(workflowSettings.isRemoveOperationIdPrefix());
        config.setEnablePostProcessFile(workflowSettings.isEnablePostProcessFile());
        config.setEnableMinimalUpdate(workflowSettings.isEnableMinimalUpdate());
        config.setStrictSpecBehavior(workflowSettings.isStrictSpecBehavior());
        TemplatingEngineAdapter templatingEngine = TemplatingEngineLoader.byIdentifier(workflowSettings.getTemplatingEngineName());
        config.setTemplatingEngine(templatingEngine);
        config.instantiationTypes().putAll(generatorSettings.getInstantiationTypes());
        config.typeMapping().putAll(generatorSettings.getTypeMappings());
        config.importMapping().putAll(generatorSettings.getImportMappings());
        config.languageSpecificPrimitives().addAll(generatorSettings.getLanguageSpecificPrimitives());
        config.reservedWordsMappings().putAll(generatorSettings.getReservedWordMappings());
        config.additionalProperties().putAll(generatorSettings.getAdditionalProperties());
        Map serverVariables = generatorSettings.getServerVariables();
        if (!serverVariables.isEmpty()) {
            LOGGER.warn("user-defined server variable support is experimental.");
            config.serverVariableOverrides().putAll(serverVariables);
        }
        if ((templateDir = workflowSettings.getTemplateDir()) != null) {
            config.additionalProperties().put("templateDir", workflowSettings.getTemplateDir());
        }
        ClientOptInput input = new ClientOptInput().config(config);
        return input.openAPI((OpenAPI)context.getSpecDocument());
    }

    private static /* synthetic */ void lambda$toContext$2(StringBuilder sb, String msg) {
        sb.append("\t-").append(msg).append(System.lineSeparator());
    }

    private static /* synthetic */ void lambda$toContext$1(StringBuilder sb, String msg) {
        sb.append("\t-").append(msg).append(System.lineSeparator());
    }
}

