/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.multipart;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.s3.multipart.ParallelConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class MultipartConfiguration
implements ToCopyableBuilder<Builder, MultipartConfiguration> {
    private final Long thresholdInBytes;
    private final Long minimumPartSizeInBytes;
    private final Long apiCallBufferSizeInBytes;
    private final ParallelConfiguration parallelConfiguration;

    private MultipartConfiguration(DefaultMultipartConfigBuilder builder) {
        this.thresholdInBytes = builder.thresholdInBytes;
        this.minimumPartSizeInBytes = builder.minimumPartSizeInBytes;
        this.apiCallBufferSizeInBytes = builder.apiCallBufferSizeInBytes;
        this.parallelConfiguration = builder.parallelConfiguration;
    }

    public static Builder builder() {
        return new DefaultMultipartConfigBuilder();
    }

    public Builder toBuilder() {
        return MultipartConfiguration.builder().apiCallBufferSizeInBytes(this.apiCallBufferSizeInBytes).minimumPartSizeInBytes(this.minimumPartSizeInBytes).thresholdInBytes(this.thresholdInBytes);
    }

    public Long thresholdInBytes() {
        return this.thresholdInBytes;
    }

    public Long minimumPartSizeInBytes() {
        return this.minimumPartSizeInBytes;
    }

    public Long apiCallBufferSizeInBytes() {
        return this.apiCallBufferSizeInBytes;
    }

    public ParallelConfiguration parallelConfiguration() {
        return this.parallelConfiguration;
    }

    private static class DefaultMultipartConfigBuilder
    implements Builder {
        private Long thresholdInBytes;
        private Long minimumPartSizeInBytes;
        private Long apiCallBufferSizeInBytes;
        private ParallelConfiguration parallelConfiguration;

        private DefaultMultipartConfigBuilder() {
        }

        @Override
        public Builder thresholdInBytes(Long thresholdInBytes) {
            this.thresholdInBytes = thresholdInBytes;
            return this;
        }

        @Override
        public Long thresholdInBytes() {
            return this.thresholdInBytes;
        }

        @Override
        public Builder minimumPartSizeInBytes(Long minimumPartSizeInBytes) {
            this.minimumPartSizeInBytes = minimumPartSizeInBytes;
            return this;
        }

        @Override
        public Long minimumPartSizeInBytes() {
            return this.minimumPartSizeInBytes;
        }

        @Override
        public Builder parallelConfiguration(ParallelConfiguration parallelConfiguration) {
            this.parallelConfiguration = parallelConfiguration;
            return this;
        }

        @Override
        public Builder parallelConfiguration(Consumer<ParallelConfiguration.Builder> configuration) {
            ParallelConfiguration.Builder builder = ParallelConfiguration.builder();
            configuration.accept(builder);
            return this.parallelConfiguration(builder.build());
        }

        @Override
        public ParallelConfiguration parallelConfiguration() {
            return this.parallelConfiguration;
        }

        @Override
        public Builder apiCallBufferSizeInBytes(Long maximumMemoryUsageInBytes) {
            this.apiCallBufferSizeInBytes = maximumMemoryUsageInBytes;
            return this;
        }

        @Override
        public Long apiCallBufferSizeInBytes() {
            return this.apiCallBufferSizeInBytes;
        }

        public MultipartConfiguration build() {
            return new MultipartConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MultipartConfiguration> {
        public Builder thresholdInBytes(Long var1);

        public Long thresholdInBytes();

        public Builder minimumPartSizeInBytes(Long var1);

        public Long minimumPartSizeInBytes();

        public Builder apiCallBufferSizeInBytes(Long var1);

        public Long apiCallBufferSizeInBytes();

        public Builder parallelConfiguration(ParallelConfiguration var1);

        public Builder parallelConfiguration(Consumer<ParallelConfiguration.Builder> var1);

        public ParallelConfiguration parallelConfiguration();
    }
}

