/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE jsonreleaseinfoFile
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this jsonreleaseinfoFile
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this jsonreleaseinfoFile except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.nbbuild;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 *
 * @author skygo
 */
public class SetApidocClustersConfig extends Task {

    /**
     * current branch we works with
     */
    private String branch;

    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public void execute() throws BuildException {
        super.execute();
        if (branch.equals("master")) {
// for master branch, more apidoc to generate
            String list = getProject().getProperty("config.javadoc.stable");
            list += add("config.javadoc.deprecated");
            list += add("config.javadoc.devel");
            list += add("config.javadoc.friend");
            getProject().setProperty("config.javadoc.all", list);
        } else {
// for release branch only stable
            getProject().setProperty("config.javadoc.all", getProject().getProperty("config.javadoc.stable"));
        }
    }

    private String add(String prop) {
        String val = getProject().getProperty(prop);
        return (val == null || val.trim().isEmpty()) ? "" : "," + val;
    }
}
