/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.Serializable;

public abstract class Union2<First, Second>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;

    Union2() {
    }

    public abstract First first() throws IllegalArgumentException;

    public abstract Second second() throws IllegalArgumentException;

    public abstract boolean hasFirst();

    public abstract boolean hasSecond();

    public abstract Union2<First, Second> clone();

    public static <First, Second> Union2<First, Second> createFirst(First first) {
        return new Union2First(first);
    }

    public static <First, Second> Union2<First, Second> createSecond(Second second) {
        return new Union2Second(second);
    }

    private static final class Union2First<First, Second>
    extends Union2<First, Second> {
        private static final long serialVersionUID = 1L;
        private final First first;

        public Union2First(First first) {
            this.first = first;
        }

        @Override
        public First first() throws IllegalArgumentException {
            return this.first;
        }

        @Override
        public Second second() throws IllegalArgumentException {
            throw new IllegalArgumentException();
        }

        @Override
        public boolean hasFirst() {
            return true;
        }

        @Override
        public boolean hasSecond() {
            return false;
        }

        public String toString() {
            return String.valueOf(this.first);
        }

        public boolean equals(Object obj) {
            return this.first != null ? obj instanceof Union2First && this.first.equals(((Union2First)obj).first) : obj == null;
        }

        public int hashCode() {
            return this.first != null ? this.first.hashCode() : 0;
        }

        @Override
        public Union2<First, Second> clone() {
            return Union2First.createFirst(this.first);
        }
    }

    private static final class Union2Second<First, Second>
    extends Union2<First, Second> {
        private static final long serialVersionUID = 1L;
        private final Second second;

        public Union2Second(Second second) {
            this.second = second;
        }

        @Override
        public First first() throws IllegalArgumentException {
            throw new IllegalArgumentException();
        }

        @Override
        public Second second() throws IllegalArgumentException {
            return this.second;
        }

        @Override
        public boolean hasFirst() {
            return false;
        }

        @Override
        public boolean hasSecond() {
            return true;
        }

        public String toString() {
            return String.valueOf(this.second);
        }

        public boolean equals(Object obj) {
            return this.second != null ? obj instanceof Union2Second && this.second.equals(((Union2Second)obj).second) : obj == null;
        }

        public int hashCode() {
            return this.second != null ? this.second.hashCode() : 0;
        }

        @Override
        public Union2<First, Second> clone() {
            return Union2Second.createSecond(this.second);
        }
    }
}

