/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.LazyHintComputation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class LazyHintComputationFactory
extends EditorAwareJavaSourceTaskFactory {
    private static Map<FileObject, List<Reference<CreatorBasedLazyFixList>>> file2Creators = new WeakHashMap<FileObject, List<Reference<CreatorBasedLazyFixList>>>();

    public LazyHintComputationFactory() {
        super(JavaSource.Phase.RESOLVED, JavaSource.Priority.LOW);
    }

    @Override
    public CancellableTask<CompilationInfo> createTask(FileObject file) {
        return new LazyHintComputation(file);
    }

    private static void rescheduleImpl(FileObject file) {
        LazyHintComputationFactory f = Lookup.getDefault().lookup(LazyHintComputationFactory.class);
        if (f != null) {
            f.reschedule(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToCompute(FileObject file, CreatorBasedLazyFixList list) {
        Class<LazyHintComputationFactory> clazz = LazyHintComputationFactory.class;
        synchronized (LazyHintComputationFactory.class) {
            List<Reference<CreatorBasedLazyFixList>> references = file2Creators.get(file);
            if (references == null) {
                references = new ArrayList<Reference<CreatorBasedLazyFixList>>();
                file2Creators.put(file, references);
            }
            references.add(new WeakReference<CreatorBasedLazyFixList>(list));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            LazyHintComputationFactory.rescheduleImpl(file);
            return;
        }
    }

    public static synchronized List<CreatorBasedLazyFixList> getAndClearToCompute(FileObject file) {
        List<Reference<CreatorBasedLazyFixList>> references = file2Creators.get(file);
        if (references == null) {
            return Collections.emptyList();
        }
        ArrayList<CreatorBasedLazyFixList> result = new ArrayList<CreatorBasedLazyFixList>();
        for (Reference<CreatorBasedLazyFixList> r : references) {
            CreatorBasedLazyFixList c = r.get();
            if (c == null) continue;
            result.add(c);
        }
        references.clear();
        return result;
    }
}

