/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Parameters;

public final class CommonModuleUtils {
    public static final SpecificationVersion JDK9 = new SpecificationVersion("9");
    private static final String ARG_ADDMODS = "--add-modules";
    private static final String ARG_PATCH_MOD = "--patch-module";
    private static final String ARG_XMODULE = "-XD-Xmodule";
    private static final Pattern MATCHER_XMODULE = Pattern.compile(String.format("%s:(\\S+)", "-XD-Xmodule"));
    private static final Pattern MATCHER_PATCH = Pattern.compile("(.+)=(.+)");

    private CommonModuleUtils() {
        throw new IllegalStateException("No instance allowed.");
    }

    @NonNull
    public static Set<String> getAddModules(@NonNull CompilerOptionsQuery.Result res) {
        Parameters.notNull("res", res);
        HashSet<String> mods = new HashSet<String>();
        boolean addmod = false;
        for (String string : res.getArguments()) {
            if (addmod) {
                mods.addAll(Arrays.stream(string.split(",")).map(m -> m.trim()).collect(Collectors.toList()));
            }
            addmod = ARG_ADDMODS.equals(string);
        }
        return mods;
    }

    @CheckForNull
    public static String getXModule(@NonNull CompilerOptionsQuery.Result res) {
        Parameters.notNull("res", res);
        String module = null;
        for (String string : res.getArguments()) {
            Matcher m = MATCHER_XMODULE.matcher(string);
            if (!m.matches()) continue;
            module = m.group(1);
            break;
        }
        return module;
    }

    @NonNull
    public static Map<String, List<URL>> getPatches(@NonNull CompilerOptionsQuery.Result res) {
        Parameters.notNull("res", res);
        HashMap<String, List<URL>> patches = new HashMap<String, List<URL>>();
        boolean patch = false;
        for (String string : res.getArguments()) {
            Matcher m;
            if (patch && (m = MATCHER_PATCH.matcher(string)).matches() && m.groupCount() == 2) {
                String module = m.group(1);
                String path = m.group(2);
                if (!module.isEmpty() && !path.isEmpty()) {
                    patches.putIfAbsent(module, Arrays.stream(PropertyUtils.tokenizePath(path)).map(p -> FileUtil.normalizeFile(new File((String)p))).map(FileUtil::urlForArchiveOrDir).collect(Collectors.toList()));
                }
            }
            patch = ARG_PATCH_MOD.equals(string);
        }
        return patches;
    }

    @NonNull
    public static Collection<? extends String> parseSourcePathVariants(@NonNull String pathEntry) {
        LinkedHashSet res = new LinkedHashSet();
        CommonModuleUtils.parseSourcePathVariantsImpl(pathEntry, res);
        return res;
    }

    private static void parseSourcePathVariantsImpl(@NonNull String path, @NonNull Collection<? super String> collector) {
        int[] index = CommonModuleUtils.findGroup(path);
        if (index == null) {
            collector.add(path);
        } else {
            String prefix = path.substring(0, index[0]);
            String suffix = path.substring(index[1]);
            for (String string : CommonModuleUtils.expandGroup(path, index[0], index[1])) {
                CommonModuleUtils.parseSourcePathVariantsImpl(prefix + string + suffix, collector);
            }
        }
    }

    private static int[] findGroup(@NonNull String path) {
        int start = path.indexOf(123);
        if (start == -1) {
            return null;
        }
        int depth = 1;
        int end = start + 1;
        while (end < path.length() && depth > 0) {
            char c = path.charAt(end++);
            switch (c) {
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    --depth;
                }
            }
        }
        return new int[]{start, end};
    }

    private static Collection<? extends String> expandGroup(@NonNull String path, int start, int end) {
        ArrayList<String> res = new ArrayList<String>();
        int depth = 0;
        StringBuilder current = new StringBuilder();
        block5: for (int i = start; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '{': {
                    if (depth > 0) {
                        current.append(c);
                    }
                    ++depth;
                    continue block5;
                }
                case '}': {
                    if (--depth <= 0) continue block5;
                    current.append(c);
                    continue block5;
                }
                case ',': {
                    if (depth == 1) {
                        res.add(current.toString());
                        current.delete(0, current.length());
                        continue block5;
                    }
                    current.append(c);
                    continue block5;
                }
                default: {
                    current.append(c);
                }
            }
        }
        res.add(current.toString());
        return res;
    }
}

