/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.spi.connector.transport.http.RFC9457;

import java.io.IOException;
import org.eclipse.aether.spi.connector.transport.http.RFC9457.BiConsumerChecked;
import org.eclipse.aether.spi.connector.transport.http.RFC9457.HttpRFC9457Exception;
import org.eclipse.aether.spi.connector.transport.http.RFC9457.RFC9457Parser;
import org.eclipse.aether.spi.connector.transport.http.RFC9457.RFC9457Payload;

public abstract class RFC9457Reporter<T, E extends Exception> {
    protected abstract boolean isRFC9457Message(T var1);

    protected abstract int getStatusCode(T var1);

    protected abstract String getReasonPhrase(T var1);

    protected abstract String getBody(T var1) throws IOException;

    protected boolean hasRFC9457ContentType(String contentType) {
        return "application/problem+json".equals(contentType);
    }

    public void generateException(T response, BiConsumerChecked<Integer, String, E> baseException) throws E, HttpRFC9457Exception {
        int statusCode = this.getStatusCode(response);
        String reasonPhrase = this.getReasonPhrase(response);
        if (this.isRFC9457Message(response)) {
            String body;
            try {
                body = this.getBody(response);
            }
            catch (IOException ignore) {
                throw new HttpRFC9457Exception(statusCode, reasonPhrase, RFC9457Payload.INSTANCE);
            }
            if (body != null && !body.isEmpty()) {
                RFC9457Payload rfc9457Payload = RFC9457Parser.parse(body);
                throw new HttpRFC9457Exception(statusCode, reasonPhrase, rfc9457Payload);
            }
            throw new HttpRFC9457Exception(statusCode, reasonPhrase, RFC9457Payload.INSTANCE);
        }
        baseException.accept(statusCode, reasonPhrase);
    }
}

