/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel.set;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.processors.query.calcite.rel.set.IgniteSetOp;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public interface IgniteReduceSetOp
extends IgniteSetOp {
    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)RewindabilityTrait.ONE_WAY), (Object)ImmutableList.of((Object)inputTraits.get(0))));
    }

    @Override
    default public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        if (TraitUtils.distribution(nodeTraits) == IgniteDistributions.single()) {
            return Pair.of((Object)nodeTraits, Commons.transform(inTraits, t -> t.replace((RelTrait)IgniteDistributions.single())));
        }
        return null;
    }

    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.single()), (Object)ImmutableList.of((Object)inputTraits.get(0).replace((RelTrait)IgniteDistributions.single()))));
    }

    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)TraitUtils.correlation(inTraits.get(0))), inTraits));
    }

    @Override
    default public AggregateType aggregateType() {
        return AggregateType.REDUCE;
    }
}

