/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.util.typedef.F;

public abstract class AbstractCacheScan<Row>
implements Iterable<Row>,
AutoCloseable {
    protected final GridCacheContext<?, ?> cctx;
    protected final ExecutionContext<Row> ectx;
    protected final AffinityTopologyVersion topVer;
    protected final int[] parts;
    protected volatile List<GridDhtLocalPartition> reserved;

    AbstractCacheScan(ExecutionContext<Row> ectx, GridCacheContext<?, ?> cctx, int[] parts) {
        this.ectx = ectx;
        this.cctx = cctx;
        this.parts = parts;
        this.topVer = ectx.topologyVersion();
    }

    @Override
    public final Iterator<Row> iterator() {
        this.reserve();
        try {
            return this.createIterator();
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
    }

    protected abstract Iterator<Row> createIterator();

    @Override
    public void close() {
        this.release();
    }

    private synchronized void reserve() {
        List<GridDhtLocalPartition> toReserve;
        if (this.reserved != null) {
            return;
        }
        GridDhtPartitionTopology top = this.cctx.topology();
        top.readLock();
        GridDhtTopologyFuture topFut = top.topologyVersionFuture();
        boolean done = topFut.isDone();
        if (!done || topFut.topologyVersion().compareTo(this.topVer) < 0 || this.cctx.shared().exchange().lastAffinityChangedTopologyVersion(topFut.initialVersion()).compareTo(this.topVer) > 0) {
            top.readUnlock();
            throw new ClusterTopologyException("Topology was changed. Please retry on stable topology.");
        }
        if (this.cctx.isReplicated()) {
            int partsCnt = this.cctx.affinity().partitions();
            toReserve = new ArrayList<GridDhtLocalPartition>(partsCnt);
            for (int i = 0; i < partsCnt; ++i) {
                toReserve.add(top.localPartition(i));
            }
        } else if (this.cctx.isPartitioned()) {
            assert (this.parts != null);
            toReserve = new ArrayList<GridDhtLocalPartition>(this.parts.length);
            for (int i = 0; i < this.parts.length; ++i) {
                toReserve.add(top.localPartition(this.parts[i]));
            }
        } else {
            toReserve = Collections.emptyList();
        }
        ArrayList<GridDhtLocalPartition> reserved = new ArrayList<GridDhtLocalPartition>(toReserve.size());
        try {
            for (GridDhtLocalPartition part : toReserve) {
                if (part == null || !part.reserve()) {
                    throw new ClusterTopologyException("Failed to reserve partition for query execution. Retry on stable topology.");
                }
                if (part.state() != GridDhtPartitionState.OWNING) {
                    part.release();
                    throw new ClusterTopologyException("Failed to reserve partition for query execution. Retry on stable topology.");
                }
                reserved.add(part);
            }
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
        finally {
            this.reserved = reserved;
            top.readUnlock();
        }
    }

    private synchronized void release() {
        if (F.isEmpty(this.reserved)) {
            return;
        }
        this.reserved.forEach(GridDhtLocalPartition::release);
        this.reserved = null;
    }
}

