/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class StackLayout
extends Layout {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public Control topControl;

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        int maxWidth = 0;
        int maxHeight = 0;
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            Point size = element.computeSize(wHint, hHint, flushCache);
            maxWidth = Math.max(size.x, maxWidth);
            maxHeight = Math.max(size.y, maxHeight);
            ++n2;
        }
        int width = maxWidth + 2 * this.marginWidth;
        int height = maxHeight + 2 * this.marginHeight;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    @Override
    protected boolean flushCache(Control control) {
        return true;
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        rect.x += this.marginWidth;
        rect.y += this.marginHeight;
        rect.width -= 2 * this.marginWidth;
        rect.height -= 2 * this.marginHeight;
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            element.setBounds(rect);
            element.setVisible(element == this.topControl);
            ++n2;
        }
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    public String toString() {
        Object string = this.getName() + " {";
        if (this.marginWidth != 0) {
            string = (String)string + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = (String)string + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.topControl != null) {
            string = (String)string + "topControl=" + String.valueOf(this.topControl) + " ";
        }
        string = ((String)string).trim();
        string = (String)string + "}";
        return string;
    }
}

