/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ArabicOption;
import com.ibm.as400.access.ArabicOptionSet;
import com.ibm.as400.access.BidiFlag;
import com.ibm.as400.access.BidiFlagSet;

class BidiShape {
    static final char Tail = '\u200b';
    private static final short[][][] shapeTable = new short[][][]{new short[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 3}, {0, 1, 0, 1}}, new short[][]{{0, 0, 2, 2}, {0, 0, 1, 2}, {0, 1, 1, 2}, {0, 1, 1, 3}}, new short[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 3}, {0, 1, 0, 3}}, new short[][]{{0, 0, 1, 2}, {0, 0, 1, 2}, {0, 1, 1, 2}, {0, 1, 1, 3}}};
    private static final int[] convertFEto06 = new int[]{1611, 1611, 1612, 1612, 1613, 1613, 1614, 1614, 1615, 1615, 1616, 1616, 1617, 1617, 1618, 1618, 1569, 1570, 1570, 1571, 1571, 1572, 1572, 1573, 1573, 1574, 1574, 1574, 1574, 1575, 1575, 1576, 1576, 1576, 1576, 1577, 1577, 1578, 1578, 1578, 1578, 1579, 1579, 1579, 1579, 1580, 1580, 1580, 1580, 1581, 1581, 1581, 1581, 1582, 1582, 1582, 1582, 1583, 1583, 1584, 1584, 1585, 1585, 1586, 1586, 1587, 1587, 1587, 1587, 1588, 1588, 1588, 1588, 1589, 1589, 1589, 1589, 1590, 1590, 1590, 1590, 1591, 1591, 1591, 1591, 1592, 1592, 1592, 1592, 1593, 1593, 1593, 1593, 1594, 1594, 1594, 1594, 1601, 1601, 1601, 1601, 1602, 1602, 1602, 1602, 1603, 1603, 1603, 1603, 1604, 1604, 1604, 1604, 1605, 1605, 1605, 1605, 1606, 1606, 1606, 1606, 1607, 1607, 1607, 1607, 1608, 1608, 1609, 1609, 1610, 1610, 1610, 1610, 1628, 1628, 1629, 1629, 1630, 1630, 1631, 1631};
    private static final int[] convert06toFE = new int[]{16, 17, 19, 21, 23, 25, 29, 31, 35, 37, 41, 45, 49, 53, 57, 59, 61, 63, 65, 69, 73, 77, 81, 85, 89, 93, 0, 0, 0, 0, 0, 0, 97, 101, 105, 109, 113, 117, 121, 125, 127, 129, 0, 2, 4, 6, 8, 10, 12, 14};
    private static final int[] Link06 = new int[]{4385, 4897, 5377, 5921, 6403, 7457, 7939, 8961, 9475, 10499, 11523, 12547, 13571, 14593, 15105, 15617, 16129, 16643, 17667, 18691, 19715, 20739, 21763, 22787, 23811, 0, 0, 0, 0, 0, 3, 24835, 25859, 26883, 27923, 28931, 29955, 30979, 32001, 32513, 33027, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 34049, 34561, 35073, 35585, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 33, 33, 0, 33, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 3, 3, 3, 1, 1};
    private static final short[] LinkFE = new short[]{3, 3, 3, 0, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 32, 33, 32, 33, 0, 1, 32, 33, 0, 2, 3, 1, 32, 33, 0, 2, 3, 1, 0, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 16, 18, 19, 17, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 1, 0, 1, 0, 2, 3, 1, 0, 1, 0, 1, 0, 1, 0, 1};
    private static final short[] IrreleventPos = new short[]{0, 2, 4, 6, 8, 10, 12, 14};
    static char[] AlefType = new char[]{'\u0622', '\u0622', '\u0623', '\u0623', '\u0625', '\u0625', '\u0627', '\u0627'};
    static char[] Tashkeel = new char[]{'\ufe70', '\ufe72', '\ufe74', '\ufe76', '\ufe78', '\ufe7a', '\ufe7c', '\ufe7e'};
    static char[] Tashkeel_Tatweel = new char[]{'\ufe71', '\ufe72', '\ufe74', '\ufe77', '\ufe79', '\ufe7b', '\ufe7d', '\ufe7f'};
    private static final int LINKR = 1;
    private static final int LINKL = 2;
    private static final int IRRELEVANT = 4;
    private static final int LAMTYPE = 16;
    private static final int ALEFTYPE = 32;
    private static final int LINKFIELD = 3;

    BidiShape() {
    }

    synchronized void shapingRoutine(BidiFlagSet inAttr, BidiFlagSet outAttr, char[] str, boolean rtl) {
        block22: {
            int step;
            int iEnd;
            int Ix;
            BidiFlag outTextShape;
            BidiFlag outTextType;
            int prevLink;
            int nextLink;
            int lastLink;
            block21: {
                lastLink = 0;
                nextLink = 0;
                prevLink = 0;
                int bufLen = str.length;
                if (bufLen == 0) {
                    return;
                }
                BidiFlag inTextType = inAttr.getType();
                outTextType = outAttr.getType();
                outTextShape = outAttr.getText();
                if (inTextType != BidiFlag.TYPE_VISUAL || outTextType != BidiFlag.TYPE_IMPLICIT) break block21;
                for (int idx = 0; idx < bufLen; ++idx) {
                    if (str[idx] < '\ufe70' || str[idx] > '\ufef4') continue;
                    int newCharValue = str[idx] - 65136;
                    str[idx] = (char)convertFEto06[newCharValue];
                }
                break block22;
            }
            if (outTextType != BidiFlag.TYPE_VISUAL) break block22;
            if (rtl) {
                Ix = 0;
                iEnd = str.length;
                step = 1;
            } else {
                Ix = str.length - 1;
                iEnd = -1;
                step = -1;
            }
            prevLink = 0;
            lastLink = 0;
            int currLink = BidiShape.uba_getLink(str[Ix]);
            int prevPos = Ix;
            int lastPos = Ix;
            int Nx = -2;
            while (Ix != iEnd) {
                if ((currLink & 0xFF00) > 0) {
                    int Nw = Ix + step;
                    while (Nx < 0) {
                        if (Nw == iEnd) {
                            nextLink = 0;
                            Nx = 30000;
                            continue;
                        }
                        nextLink = BidiShape.uba_getLink(str[Nw]);
                        if ((nextLink & 4) == 0) {
                            Nx = Nw;
                            continue;
                        }
                        Nw += step;
                    }
                    if ((currLink & 0x20) > 0 && (lastLink & 0x10) > 0) {
                        char wLamalef = BidiShape.Lamalef(str[Ix]);
                        if (wLamalef != '\u0000') {
                            int h;
                            if (rtl) {
                                str[lastPos] = wLamalef;
                                for (h = Ix; h < str.length - 1; ++h) {
                                    str[h] = str[h + 1];
                                }
                                str[str.length - 1] = 32;
                                Ix = lastPos;
                            } else {
                                str[lastPos] = wLamalef;
                                for (h = Ix; h > 0; --h) {
                                    str[h] = str[h - 1];
                                }
                                str[0] = 32;
                                Ix = lastPos;
                            }
                        }
                        lastLink = prevLink;
                        currLink = BidiShape.uba_getLink(wLamalef);
                        Nx = -2;
                    }
                    int flag = BidiShape.specialChar(str[Ix]);
                    int Shape = outTextShape == BidiFlag.TEXT_INITIAL ? (flag == 0 ? 2 : 0) : (outTextShape == BidiFlag.TEXT_MIDDLE ? (flag == 0 ? 3 : 1) : (outTextShape == BidiFlag.TEXT_FINAL ? (flag == 0 ? 1 : 1) : (outTextShape == BidiFlag.TEXT_ISOLATED ? 0 : shapeTable[nextLink & 3][lastLink & 3][currLink & 3])));
                    str[Ix] = (char)(65136 + (currLink >> 8) + Shape);
                }
                if ((currLink & 4) == 0) {
                    prevLink = lastLink;
                    lastLink = currLink;
                    prevPos = lastPos;
                    lastPos = Ix;
                }
                if ((currLink & 4) > 0 && 0 <= str[Ix] - 1611 && str[Ix] - 1611 < IrreleventPos.length) {
                    int charidx = str[Ix] - 1611;
                    int MyShape = 0;
                    int next = nextLink & 3;
                    int last = lastLink & 3;
                    if (last == 3 && next == 1 || last == 3 && next == 3) {
                        MyShape = 1;
                    }
                    if ((nextLink & 0x20) > 0 && (lastLink & 0x10) > 0) {
                        MyShape = 0;
                    }
                    if (str[Ix] == '\u064c' || str[Ix] == '\u064d') {
                        MyShape = 0;
                    }
                    str[Ix] = (char)(65136 + IrreleventPos[charidx] + MyShape);
                }
                if ((Ix += step) == Nx) {
                    currLink = nextLink;
                    Nx = -2;
                    continue;
                }
                if (Ix == iEnd) continue;
                currLink = BidiShape.uba_getLink(str[Ix]);
            }
        }
    }

    synchronized char[] shape(BidiFlagSet inAttr, BidiFlagSet outAttr, char[] str, ArabicOptionSet optionSet) {
        boolean rtl = true;
        int bufLen = str.length;
        if (bufLen == 0) {
            return str;
        }
        if (optionSet == null) {
            optionSet = new ArabicOptionSet();
        }
        BidiFlag inTextType = inAttr.getType();
        BidiFlag outTextType = outAttr.getType();
        rtl = outAttr.getOrientation() == BidiFlag.ORIENTATION_RTL;
        BidiFlag outTextShape = outAttr.getText();
        ArabicOption lamAlefOpt = optionSet.getLamAlefMode();
        ArabicOption seenOpt = optionSet.getSeenMode();
        ArabicOption yehHamzaOpt = optionSet.getYehHamzaMode();
        ArabicOption tashkeelOpt = optionSet.getTashkeelMode();
        if (inTextType == BidiFlag.TYPE_VISUAL && outTextType == BidiFlag.TYPE_IMPLICIT) {
            if (seenOpt == ArabicOption.SEEN_NEAR || seenOpt == ArabicOption.SEEN_AUTO) {
                this.deshapeSeenNear(str, bufLen);
            }
            if (yehHamzaOpt == ArabicOption.YEHHAMZA_TWO_CELL_NEAR || yehHamzaOpt == ArabicOption.YEHHAMZA_AUTO) {
                this.deshapeYehHamzaTwoCellNear(str, bufLen);
            }
            if (tashkeelOpt != ArabicOption.TASHKEEL_KEEP && tashkeelOpt != ArabicOption.TASHKEEL_AUTO) {
                if (tashkeelOpt == ArabicOption.TASHKEEL_CUSTOMIZED_ATBEGIN) {
                    this.customizeTashkeelAtBegin(str, bufLen);
                } else if (tashkeelOpt == ArabicOption.TASHKEEL_CUSTOMIZED_ATEND) {
                    this.customizeTashkeelAtEnd(str, bufLen);
                }
            }
            if (lamAlefOpt == ArabicOption.LAMALEF_RESIZE_BUFFER) {
                str = this.deshapeLamAlefWithResizeBuffer(str, bufLen);
                bufLen = str.length;
            } else if (lamAlefOpt == ArabicOption.LAMALEF_NEAR) {
                this.deshapeLamAlefNear(str, bufLen);
            } else if (lamAlefOpt == ArabicOption.LAMALEF_ATBEGIN) {
                this.deshapeLamAlefAtBegin(str, bufLen);
            } else if (lamAlefOpt == ArabicOption.LAMALEF_ATEND) {
                this.deshapeLamAlefAtEnd(str, bufLen);
            } else if (lamAlefOpt == ArabicOption.LAMALEF_AUTO) {
                this.deshapeLamAlefAuto(str, bufLen, rtl);
            }
            this.shapingRoutine(inAttr, outAttr, str, rtl);
        } else if (outTextType == BidiFlag.TYPE_VISUAL) {
            this.shapingRoutine(inAttr, outAttr, str, rtl);
            if (seenOpt == ArabicOption.SEEN_NEAR || seenOpt == ArabicOption.SEEN_AUTO) {
                this.shapeSeenNear(str, bufLen, rtl);
            }
            if (yehHamzaOpt == ArabicOption.YEHHAMZA_TWO_CELL_NEAR || yehHamzaOpt == ArabicOption.YEHHAMZA_AUTO) {
                this.shapeYehHamzaTwoCellNear(str, bufLen, rtl);
            }
            if (tashkeelOpt != ArabicOption.TASHKEEL_KEEP && tashkeelOpt != ArabicOption.TASHKEEL_AUTO) {
                if (tashkeelOpt == ArabicOption.TASHKEEL_CUSTOMIZED_ATBEGIN) {
                    this.customizeTashkeelAtBegin(str, bufLen);
                } else if (tashkeelOpt == ArabicOption.TASHKEEL_CUSTOMIZED_ATEND) {
                    this.customizeTashkeelAtEnd(str, bufLen);
                }
            }
            if (lamAlefOpt == ArabicOption.LAMALEF_RESIZE_BUFFER) {
                str = this.handleLamAlefWithResizeBuffer(str, bufLen, rtl);
                bufLen = str.length;
            } else if (lamAlefOpt == ArabicOption.LAMALEF_NEAR) {
                this.handleLamAlefNear(str, bufLen, rtl);
            } else if (lamAlefOpt == ArabicOption.LAMALEF_ATBEGIN) {
                if (rtl) {
                    this.handleLamAlefAtBegin(str, bufLen);
                }
            } else if (lamAlefOpt == ArabicOption.LAMALEF_ATEND) {
                if (!rtl) {
                    this.handleLamAlefAtEnd(str, bufLen);
                }
            } else if (lamAlefOpt == ArabicOption.LAMALEF_AUTO) {
                // empty if block
            }
        }
        return str;
    }

    private static int uba_getLink(char x) {
        if (x >= '\u0622' && x <= '\u06d3') {
            return Link06[x - 1570];
        }
        if (x == '\u200d') {
            return 3;
        }
        if (x >= '\u206d' && x <= '\u206f') {
            return 4;
        }
        if (x >= '\ufe70' && x <= '\ufefc') {
            return LinkFE[x - 65136];
        }
        return 0;
    }

    private static char Lamalef(char x) {
        switch (x) {
            case '\u0622': {
                return '\u065c';
            }
            case '\u0623': {
                return '\u065d';
            }
            case '\u0625': {
                return '\u065e';
            }
            case '\u0627': {
                return '\u065f';
            }
        }
        return '\u0000';
    }

    private static int specialChar(char ch) {
        if (ch >= '\u0621' && ch < '\u0626' || ch == '\u0627' || ch > '\u062e' && ch < '\u0633' || ch > '\u0647' && ch < '\u064a' || ch == '\u0629') {
            return 1;
        }
        return 0;
    }

    private static boolean SeenChar(char ch) {
        return ch == '\ufeb1' || ch == '\ufeb2' || ch == '\ufeb5' || ch == '\ufeb6' || ch == '\ufeb9' || ch == '\ufeba' || ch == '\ufebd' || ch == '\ufebe';
    }

    private char[] handleLamAlefWithResizeBuffer(char[] buffer, int length, boolean rtl) {
        int counter = 0;
        int lamAlefCount = 0;
        for (counter = 0; counter < length; ++counter) {
            if (buffer[counter] < '\ufef5' || buffer[counter] > '\ufefc') continue;
            ++lamAlefCount;
        }
        if (lamAlefCount == 0) {
            return buffer;
        }
        char[] compressedBuffer = new char[length - lamAlefCount];
        if (rtl) {
            System.arraycopy(buffer, 0, compressedBuffer, 0, buffer.length - lamAlefCount);
        } else {
            System.arraycopy(buffer, lamAlefCount, compressedBuffer, 0, buffer.length - lamAlefCount);
        }
        return compressedBuffer;
    }

    private char[] deshapeLamAlefWithResizeBuffer(char[] buffer, int length) {
        int oldBufferCounter = 0;
        int newBufferCounter = 0;
        int lamAlefCount = 0;
        for (oldBufferCounter = 0; oldBufferCounter < length; ++oldBufferCounter) {
            if (buffer[oldBufferCounter] < '\ufef5' || buffer[oldBufferCounter] > '\ufefc') continue;
            ++lamAlefCount;
        }
        if (lamAlefCount == 0) {
            return buffer;
        }
        char[] expandedBuffer = new char[length + lamAlefCount];
        for (oldBufferCounter = 0; oldBufferCounter < length; ++oldBufferCounter) {
            if (buffer[oldBufferCounter] >= '\ufef5' && buffer[oldBufferCounter] <= '\ufefc') {
                char ChAlefType = AlefType[buffer[oldBufferCounter] - 65269];
                expandedBuffer[newBufferCounter] = 1604;
                expandedBuffer[++newBufferCounter] = ChAlefType;
            } else {
                expandedBuffer[newBufferCounter] = buffer[oldBufferCounter];
            }
            ++newBufferCounter;
        }
        return expandedBuffer;
    }

    private void handleLamAlefNear(char[] buffer, int length, boolean rtl) {
        for (int count = 0; count < length; ++count) {
            int tempIdx;
            if (buffer[count] >= '\ufef5' && buffer[count] <= '\ufefc' && buffer[length - 1] == ' ' && rtl) {
                for (tempIdx = length - 1; tempIdx > count + 1; --tempIdx) {
                    buffer[tempIdx] = buffer[tempIdx - 1];
                }
                if (count >= length - 1) continue;
                buffer[count + 1] = 32;
                continue;
            }
            if (buffer[count] < '\ufef5' || buffer[count] > '\ufefc' || buffer[0] != ' ' || rtl) continue;
            for (tempIdx = 0; tempIdx < count - 1; ++tempIdx) {
                buffer[tempIdx] = buffer[tempIdx + 1];
            }
            if (count == 0) continue;
            buffer[count - 1] = 32;
        }
    }

    private void deshapeLamAlefNear(char[] buffer, int length) {
        for (int count = 1; count < length; ++count) {
            char ChAlefType;
            if (buffer[count] < '\ufef5' || buffer[count] > '\ufefc' || count == length - 1 || buffer[count + 1] != ' ') continue;
            buffer[count + 1] = ChAlefType = AlefType[buffer[count] - 65269];
            buffer[count] = 1604;
        }
    }

    private void handleLamAlefAtBegin(char[] buffer, int length) {
        int lamAlefOccurences = 0;
        for (int count = 0; count < length; ++count) {
            if (buffer[count] < '\ufef5' || buffer[count] > '\ufefc' || buffer[length - 1] != ' ') continue;
            for (int tempIdx = length - 1; tempIdx > lamAlefOccurences; --tempIdx) {
                buffer[tempIdx] = buffer[tempIdx - 1];
            }
            buffer[lamAlefOccurences] = 32;
            ++lamAlefOccurences;
            ++count;
        }
    }

    private void deshapeLamAlefAtBegin(char[] buffer, int length) {
        for (int count = 0; count < length; ++count) {
            if (buffer[count] < '\ufef5' || buffer[count] > '\ufefc' || buffer[0] != ' ') continue;
            char ChAlefType = AlefType[buffer[count] - 65269];
            for (int tempIdx = 0; tempIdx < count - 1; ++tempIdx) {
                buffer[tempIdx] = buffer[tempIdx + 1];
            }
            buffer[count - 1] = 1604;
            buffer[count] = ChAlefType;
        }
    }

    private void handleLamAlefAtEnd(char[] buffer, int length) {
        int lamAlefOccurences = 0;
        for (int count = 0; count < length; ++count) {
            if (buffer[count] < '\ufef5' || buffer[count] > '\ufefc' || buffer[0] != ' ') continue;
            for (int tempIdx = 0; tempIdx < length - lamAlefOccurences - 1; ++tempIdx) {
                buffer[tempIdx] = buffer[tempIdx + 1];
            }
            buffer[length - lamAlefOccurences - 1] = 32;
            ++lamAlefOccurences;
        }
    }

    private void deshapeLamAlefAtEnd(char[] buffer, int length) {
        for (int count = 0; count < length; ++count) {
            if (buffer[count] < '\ufef5' || buffer[count] > '\ufefc' || buffer[length - 1] != ' ') continue;
            char ChAlefType = AlefType[buffer[count] - 65269];
            for (int tempIdx = length - 1; tempIdx > count + 1; --tempIdx) {
                buffer[tempIdx] = buffer[tempIdx - 1];
            }
            buffer[count] = 1604;
            buffer[count + 1] = ChAlefType;
        }
    }

    private void handleLamAlefAuto(char[] buffer, int length, boolean rtl) {
    }

    private void deshapeLamAlefAuto(char[] buffer, int length, boolean rtl) {
        for (int count = 0; count < length; ++count) {
            int h;
            char ChAlefType;
            if (buffer[count] >= '\ufef5' && buffer[count] <= '\ufefc' && buffer[length - 1] == ' ' && rtl) {
                ChAlefType = AlefType[buffer[count] - 65269];
                for (h = length - 1; h > count; --h) {
                    buffer[h] = buffer[h - 1];
                }
                buffer[count + 1] = ChAlefType;
                buffer[count] = 1604;
                continue;
            }
            if (buffer[count] < '\ufef5' || buffer[count] > '\ufefc' || buffer[0] != ' ' || rtl) continue;
            ChAlefType = AlefType[buffer[count] - 65269];
            for (h = 0; h < count; ++h) {
                buffer[h] = buffer[h + 1];
            }
            buffer[count] = ChAlefType;
            buffer[count - 1] = 1604;
        }
    }

    private void shapeSeenNear(char[] buffer, int length, boolean rtl) {
        for (int idx = 0; idx < length; ++idx) {
            if (rtl) {
                if (!BidiShape.SeenChar(buffer[idx]) || idx + 1 >= length || buffer[idx + 1] != ' ') continue;
                buffer[idx + 1] = 8203;
                continue;
            }
            if (!BidiShape.SeenChar(buffer[idx]) || idx - 1 < 0 || buffer[idx - 1] != ' ') continue;
            buffer[idx - 1] = 8203;
        }
    }

    private void deshapeSeenNear(char[] buffer, int length) {
        for (int idx = 0; idx < length; ++idx) {
            if (buffer[idx] != '\u200b') continue;
            buffer[idx] = 32;
        }
    }

    private void shapeSeenAtBegin(char[] buffer, int length, boolean rtl) {
    }

    private void deshapeSeenAtBegin(char[] buffer, int length, boolean rtl) {
    }

    private void shapeSeenAtEnd(char[] buffer, int length, boolean rtl) {
    }

    private void deshapeSeenAtEnd(char[] buffer, int length, boolean rtl) {
    }

    private void handleSeenAuto(char[] buffer, int length, boolean rtl) {
    }

    private void deshapeSeenAuto(char[] buffer, int length, boolean rtl) {
    }

    private void shapeYehHamzaTwoCellNear(char[] buffer, int length, boolean rtl) {
        int counter = 0;
        for (counter = 0; counter < length; ++counter) {
            if (rtl) {
                if (buffer[counter] == '\ufe8a') {
                    buffer[counter] = 65264;
                    if (counter + 1 < length && buffer[counter + 1] == ' ') {
                        buffer[counter + 1] = 65152;
                    }
                }
                if (buffer[counter] != '\ufe89') continue;
                buffer[counter] = 65263;
                if (counter + 1 >= length || buffer[counter + 1] != ' ') continue;
                buffer[counter + 1] = 65152;
                continue;
            }
            if (buffer[counter] == '\ufe8a') {
                buffer[counter] = 65264;
                if (counter - 1 >= 0 && buffer[counter - 1] == ' ') {
                    buffer[counter - 1] = 65152;
                }
            }
            if (buffer[counter] != '\ufe89') continue;
            buffer[counter] = 65263;
            if (counter - 1 < 0 || buffer[counter - 1] != ' ') continue;
            buffer[counter - 1] = 65152;
        }
    }

    private void deshapeYehHamzaTwoCellNear(char[] buffer, int length) {
        int counter = 0;
        for (counter = 0; counter < length; ++counter) {
            if (counter + 1 < length && buffer[counter] == '\ufef0' && buffer[counter + 1] == '\ufe80') {
                buffer[counter] = 65162;
                buffer[counter + 1] = 32;
            }
            if (counter + 1 >= length || buffer[counter] != '\ufeef' || buffer[counter + 1] != '\ufe80') continue;
            buffer[counter] = 65161;
            buffer[counter + 1] = 32;
        }
    }

    private void shapeYehHamzaAtBegin(char[] buffer, int length, boolean rtl) {
    }

    private void deshapeYehHamzaAtBegin(char[] buffer, int length) {
    }

    private void shapeYehHamzaAtEnd(char[] buffer, int length, boolean rtl) {
    }

    private void deshapeYehHamzaAtEnd(char[] buffer, int length) {
    }

    private void shapeYehHamzaAuto(char[] buffer, int length, boolean rtl) {
    }

    private void deshapeYehHamzaAuto(char[] buffer, int length) {
    }

    private void customizeTashkeelZeroWidth(char[] buffer, int length) {
    }

    private void customizeTashkeelWithWidth(char[] buffer, int length) {
    }

    private void customizeTashkeelAtBegin(char[] buffer, int length) {
        int tashkeelOcuurences = 0;
        for (int count = 0; count < length; ++count) {
            if (!(buffer[count] >= '\ufe70' && buffer[count] <= '\ufe72' || buffer[count] == '\ufe74' || buffer[count] >= '\ufe76' && buffer[count] <= '\ufe7b') && (buffer[count] < '\ufe7e' || buffer[count] > '\ufe7f')) continue;
            for (int idx = count; idx > tashkeelOcuurences; --idx) {
                buffer[idx] = buffer[idx - 1];
            }
            buffer[tashkeelOcuurences] = 32;
            ++tashkeelOcuurences;
        }
    }

    private void customizeTashkeelAtEnd(char[] buffer, int length) {
        int tashkeelOcuurences = 0;
        for (int count = 0; count < length; ++count) {
            if (!(buffer[count] >= '\ufe70' && buffer[count] <= '\ufe72' || buffer[count] == '\ufe74' || buffer[count] >= '\ufe76' && buffer[count] <= '\ufe7b') && (buffer[count] < '\ufe7e' || buffer[count] > '\ufe7f')) continue;
            for (int idx = count; idx < length - tashkeelOcuurences - 1; ++idx) {
                buffer[idx] = buffer[idx + 1];
            }
            buffer[length - tashkeelOcuurences - 1] = 32;
            ++tashkeelOcuurences;
        }
    }

    private void handleTashkeelAuto(char[] buffer, int length) {
    }
}

