/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.selectvalues;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.lineage.FieldnameLineage;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.selectvalues.SelectMetadataChange;
import org.apache.hop.pipeline.transforms.selectvalues.SelectValues;
import org.apache.hop.pipeline.transforms.selectvalues.SelectValuesData;
import org.w3c.dom.Node;

@Transform(id="SelectValues", image="selectvalues.svg", name="i18n:org.apache.hop.pipeline.transforms.selectvalues:SelectValues.Name", description="i18n:org.apache.hop.pipeline.transforms.selectvalues:SelectValues.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::SelectValuesMeta.keyword"}, documentationUrl="/pipeline/transforms/selectvalues.html")
@InjectionSupported(localizationPrefix="SelectValues.Injection.", groups={"FIELDS", "REMOVES", "METAS"})
public class SelectValuesMeta
extends BaseTransformMeta<SelectValues, SelectValuesData> {
    private static final Class<?> PKG = SelectValuesMeta.class;
    public static final int UNDEFINED = -2;
    public static final String CONST_SPACES = "        ";
    @InjectionDeep
    private SelectField[] selectFields = new SelectField[0];
    @Injection(name="SELECT_UNSPECIFIED")
    private boolean selectingAndSortingUnspecifiedFields;
    @Injection(name="REMOVE_NAME", group="REMOVES")
    private String[] deleteName = new String[0];
    @InjectionDeep
    private SelectMetadataChange[] meta = new SelectMetadataChange[0];

    public String[] getDeleteName() {
        return this.deleteName;
    }

    public void setDeleteName(String[] deleteName) {
        this.deleteName = deleteName == null ? new String[]{} : deleteName;
    }

    public void setSelectName(String[] selectName) {
        this.resizeSelectFields(selectName.length);
        for (int i = 0; i < this.selectFields.length; ++i) {
            this.selectFields[i].setName(selectName[i]);
        }
    }

    public String[] getSelectName() {
        String[] selectName = new String[this.selectFields.length];
        for (int i = 0; i < selectName.length; ++i) {
            selectName[i] = this.selectFields[i].getName();
        }
        return selectName;
    }

    public void setSelectRename(String[] selectRename) {
        if (selectRename.length > this.selectFields.length) {
            this.resizeSelectFields(selectRename.length);
        }
        for (int i = 0; i < this.selectFields.length; ++i) {
            if (i < selectRename.length) {
                this.selectFields[i].setRename(selectRename[i]);
                continue;
            }
            this.selectFields[i].setRename(null);
        }
    }

    public String[] getSelectRename() {
        String[] selectRename = new String[this.selectFields.length];
        for (int i = 0; i < selectRename.length; ++i) {
            selectRename[i] = this.selectFields[i].getRename();
        }
        return selectRename;
    }

    public void setSelectLength(int[] selectLength) {
        if (selectLength.length > this.selectFields.length) {
            this.resizeSelectFields(selectLength.length);
        }
        for (int i = 0; i < this.selectFields.length; ++i) {
            if (i < selectLength.length) {
                this.selectFields[i].setLength(selectLength[i]);
                continue;
            }
            this.selectFields[i].setLength(-2);
        }
    }

    public int[] getSelectLength() {
        int[] selectLength = new int[this.selectFields.length];
        for (int i = 0; i < selectLength.length; ++i) {
            selectLength[i] = this.selectFields[i].getLength();
        }
        return selectLength;
    }

    public void setSelectPrecision(int[] selectPrecision) {
        if (selectPrecision.length > this.selectFields.length) {
            this.resizeSelectFields(selectPrecision.length);
        }
        for (int i = 0; i < this.selectFields.length; ++i) {
            if (i < selectPrecision.length) {
                this.selectFields[i].setPrecision(selectPrecision[i]);
                continue;
            }
            this.selectFields[i].setPrecision(-2);
        }
    }

    public int[] getSelectPrecision() {
        int[] selectPrecision = new int[this.selectFields.length];
        for (int i = 0; i < selectPrecision.length; ++i) {
            selectPrecision[i] = this.selectFields[i].getPrecision();
        }
        return selectPrecision;
    }

    private void resizeSelectFields(int length) {
        int fillStartIndex = this.selectFields.length;
        this.selectFields = Arrays.copyOf(this.selectFields, length);
        for (int i = fillStartIndex; i < this.selectFields.length; ++i) {
            this.selectFields[i] = new SelectField();
            this.selectFields[i].setLength(-2);
            this.selectFields[i].setPrecision(-2);
        }
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int nrFields, int nrRemove, int nrMeta) {
        this.allocateSelect(nrFields);
        this.allocateRemove(nrRemove);
        this.allocateMeta(nrMeta);
    }

    private void allocateSelect(int nrFields) {
        this.selectFields = new SelectField[nrFields];
        for (int i = 0; i < nrFields; ++i) {
            this.selectFields[i] = new SelectField();
        }
    }

    private void allocateRemove(int nrRemove) {
        this.deleteName = new String[nrRemove];
    }

    private void allocateMeta(int nrMeta) {
        this.meta = new SelectMetadataChange[nrMeta];
        for (int i = 0; i < nrMeta; ++i) {
            this.meta[i] = new SelectMetadataChange();
        }
    }

    public Object clone() {
        int i;
        SelectValuesMeta retval = (SelectValuesMeta)((Object)super.clone());
        int nrFields = this.selectFields == null ? 0 : this.selectFields.length;
        int nrremove = this.deleteName == null ? 0 : this.deleteName.length;
        int nrmeta = this.meta == null ? 0 : this.meta.length;
        retval.allocate(nrFields, nrremove, nrmeta);
        for (i = 0; i < nrFields; ++i) {
            retval.getSelectFields()[i] = this.selectFields[i].clone();
        }
        System.arraycopy(this.deleteName, 0, retval.deleteName, 0, nrremove);
        for (i = 0; i < nrmeta; ++i) {
            retval.getMeta()[i] = this.meta[i].clone();
        }
        return retval;
    }

    private void readData(Node transform) throws HopXmlException {
        try {
            Node line;
            int i;
            Node fields = XmlHandler.getSubNode((Node)transform, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            int nrremove = XmlHandler.countNodes((Node)fields, (String)"remove");
            int nrmeta = XmlHandler.countNodes((Node)fields, (String)"meta");
            this.allocate(nrFields, nrremove, nrmeta);
            for (i = 0; i < nrFields; ++i) {
                line = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.selectFields[i] = new SelectField();
                this.selectFields[i].setName(XmlHandler.getTagValue((Node)line, (String)"name"));
                this.selectFields[i].setRename(XmlHandler.getTagValue((Node)line, (String)"rename"));
                this.selectFields[i].setLength(Const.toInt((String)XmlHandler.getTagValue((Node)line, (String)"length"), (int)-2));
                this.selectFields[i].setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)line, (String)"precision"), (int)-2));
            }
            this.selectingAndSortingUnspecifiedFields = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)fields, (String)"select_unspecified"));
            for (i = 0; i < nrremove; ++i) {
                line = XmlHandler.getSubNodeByNr((Node)fields, (String)"remove", (int)i);
                this.deleteName[i] = XmlHandler.getTagValue((Node)line, (String)"name");
            }
            for (i = 0; i < nrmeta; ++i) {
                Node metaNode = XmlHandler.getSubNodeByNr((Node)fields, (String)"meta", (int)i);
                this.meta[i] = new SelectMetadataChange();
                this.meta[i].loadXml(metaNode);
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"SelectValuesMeta.Exception.UnableToReadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.allocate(0, 0, 0);
    }

    public void getSelectFields(IRowMeta inputRowMeta, String name) throws HopTransformException {
        if (this.selectFields != null && this.selectFields.length > 0) {
            RowMeta row = new RowMeta();
            for (int i = 0; i < this.selectFields.length; ++i) {
                IValueMeta v = inputRowMeta.searchValueMeta(this.selectFields[i].getName());
                if (v == null) continue;
                if (!(v = v.clone()).getName().equals(this.selectFields[i].getRename()) && this.selectFields[i].getRename() != null && this.selectFields[i].getRename().length() > 0) {
                    v.setName(this.selectFields[i].getRename());
                    v.setOrigin(name);
                }
                if (this.selectFields[i].getLength() != -2) {
                    v.setLength(this.selectFields[i].getLength());
                    v.setOrigin(name);
                }
                if (this.selectFields[i].getPrecision() != -2) {
                    v.setPrecision(this.selectFields[i].getPrecision());
                    v.setOrigin(name);
                }
                row.addValueMeta(v);
            }
            if (this.selectingAndSortingUnspecifiedFields) {
                ArrayList<String> extra = new ArrayList<String>();
                for (int i = 0; i < inputRowMeta.size(); ++i) {
                    String fieldName = inputRowMeta.getValueMeta(i).getName();
                    if (Const.indexOfString((String)fieldName, (String[])this.getSelectName()) >= 0) continue;
                    extra.add(fieldName);
                }
                Collections.sort(extra);
                for (String fieldName : extra) {
                    IValueMeta extraValue = inputRowMeta.searchValueMeta(fieldName);
                    row.addValueMeta(extraValue);
                }
            }
            inputRowMeta.clear();
            inputRowMeta.addRowMeta((IRowMeta)row);
        }
    }

    public void getDeleteFields(IRowMeta inputRowMeta) throws HopTransformException {
        if (this.deleteName != null && this.deleteName.length > 0) {
            for (int i = 0; i < this.deleteName.length; ++i) {
                try {
                    inputRowMeta.removeValueMeta(this.deleteName[i]);
                    continue;
                }
                catch (HopValueException e) {
                    throw new HopTransformException((Throwable)e);
                }
            }
        }
    }

    public void getMetadataFields(IRowMeta inputRowMeta, String name, IVariables variables) throws HopPluginException {
        if (this.meta != null && this.meta.length > 0) {
            for (int i = 0; i < this.meta.length; ++i) {
                SelectMetadataChange metaChange = this.meta[i];
                int idx = inputRowMeta.indexOfValue(metaChange.getName());
                if (idx < 0) continue;
                IValueMeta v = inputRowMeta.getValueMeta(idx);
                if (!v.getName().equals(metaChange.getRename()) && !Utils.isEmpty((CharSequence)metaChange.getRename())) {
                    v.setName(metaChange.getRename());
                    v.setOrigin(name);
                }
                if (metaChange.getType() != 0 && v.getType() != metaChange.getType()) {
                    v = ValueMetaFactory.cloneValueMeta((IValueMeta)v, (int)metaChange.getType());
                    inputRowMeta.setValueMeta(idx, v);
                    v.setStorageType(0);
                }
                if (metaChange.getLength() != -2) {
                    v.setLength(metaChange.getLength());
                    v.setOrigin(name);
                }
                if (metaChange.getPrecision() != -2) {
                    v.setPrecision(metaChange.getPrecision());
                    v.setOrigin(name);
                }
                if (metaChange.getStorageType() >= 0) {
                    v.setStorageType(metaChange.getStorageType());
                    v.setOrigin(name);
                }
                if (!Utils.isEmpty((CharSequence)metaChange.getConversionMask())) {
                    v.setConversionMask(metaChange.getConversionMask());
                    v.setOrigin(name);
                }
                v.setDateFormatLenient(metaChange.isDateFormatLenient());
                v.setDateFormatLocale(EnvUtil.createLocale((String)metaChange.getDateFormatLocale()));
                v.setDateFormatTimeZone(EnvUtil.createTimeZone((String)metaChange.getDateFormatTimeZone()));
                v.setLenientStringToNumber(metaChange.isLenientStringToNumber());
                if (!Utils.isEmpty((CharSequence)metaChange.getEncoding())) {
                    v.setStringEncoding(metaChange.getEncoding());
                    v.setOrigin(name);
                }
                if (!Utils.isEmpty((CharSequence)metaChange.getDecimalSymbol())) {
                    v.setDecimalSymbol(metaChange.getDecimalSymbol());
                    v.setOrigin(name);
                }
                if (!Utils.isEmpty((CharSequence)metaChange.getGroupingSymbol())) {
                    v.setGroupingSymbol(metaChange.getGroupingSymbol());
                    v.setOrigin(name);
                }
                if (Utils.isEmpty((CharSequence)metaChange.getCurrencySymbol())) continue;
                v.setCurrencySymbol(metaChange.getCurrencySymbol());
                v.setOrigin(name);
            }
        }
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            IRowMeta rowMeta = inputRowMeta.clone();
            inputRowMeta.clear();
            inputRowMeta.addRowMeta(rowMeta);
            this.getSelectFields(inputRowMeta, name);
            this.getDeleteFields(inputRowMeta);
            this.getMetadataFields(inputRowMeta, name, variables);
        }
        catch (Exception e) {
            throw new HopTransformException((Throwable)e);
        }
    }

    public String getXml() {
        int i;
        StringBuilder xml = new StringBuilder(300);
        xml.append("    <fields>");
        for (i = 0; i < this.selectFields.length; ++i) {
            xml.append("      <field>");
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.selectFields[i].getName()));
            if (this.selectFields[i].getRename() != null) {
                xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"rename", (String)this.selectFields[i].getRename()));
            }
            if (this.selectFields[i].getPrecision() > 0) {
                xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"length", (int)this.selectFields[i].getLength()));
            }
            if (this.selectFields[i].getPrecision() > 0) {
                xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"precision", (int)this.selectFields[i].getPrecision()));
            }
            xml.append("      </field>");
        }
        xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"select_unspecified", (boolean)this.selectingAndSortingUnspecifiedFields));
        for (i = 0; i < this.deleteName.length; ++i) {
            xml.append("      <remove>");
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.deleteName[i]));
            xml.append("      </remove>");
        }
        for (i = 0; i < this.meta.length; ++i) {
            xml.append(this.meta[i].getXml());
        }
        xml.append("    </fields>");
        return xml.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        boolean errorFound;
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            int i;
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            errorFound = false;
            for (i = 0; i < this.selectFields.length; ++i) {
                int idx = prev.indexOfValue(this.selectFields[i].getName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + this.selectFields[i].getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.SelectedFieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + (String)errorMessage;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllSelectedFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            if (this.selectFields.length > 0) {
                for (i = 0; i < prev.size(); ++i) {
                    IValueMeta pv = prev.getValueMeta(i);
                    int idx = Const.indexOfString((String)pv.getName(), (String[])this.getSelectName());
                    if (idx >= 0) continue;
                    errorMessage = (String)errorMessage + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                    errorFound = true;
                }
                if (errorFound) {
                    errorMessage = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.FieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + (String)errorMessage;
                    cr = new CheckResult(2, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllSelectedFieldsFound2", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            }
            errorMessage = "";
            errorFound = false;
            for (i = 0; i < this.deleteName.length; ++i) {
                int idx = prev.indexOfValue(this.deleteName[i]);
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + this.deleteName[i] + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.DeSelectedFieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + (String)errorMessage;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllDeSelectedFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            errorMessage = "";
            errorFound = false;
            for (i = 0; i < this.meta.length; ++i) {
                int idx = prev.indexOfValue(this.meta[i].getName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + this.meta[i].getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.MetadataFieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + (String)errorMessage;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllMetadataFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.FieldsNotFound2", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        int[] cnt = new int[this.selectFields.length];
        errorFound = false;
        Object errorMessage = "";
        for (int i = 0; i < this.selectFields.length; ++i) {
            cnt[i] = 0;
            for (int j = 0; j < this.selectFields.length; ++j) {
                if (!this.selectFields[i].getName().equals(this.selectFields[j].getName())) continue;
                int n = i;
                cnt[n] = cnt[n] + 1;
            }
            if (cnt[i] <= 1) continue;
            if (!errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.DuplicateFieldsSpecified", (String[])new String[0]) + Const.CR;
            } else {
                errorFound = true;
            }
            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.OccurentRow", (String[])new String[]{i + " : " + this.selectFields[i].getName() + "  (" + cnt[i]}) + Const.CR;
            errorFound = true;
        }
        if (errorFound) {
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean isSelectingAndSortingUnspecifiedFields() {
        return this.selectingAndSortingUnspecifiedFields;
    }

    public void setSelectingAndSortingUnspecifiedFields(boolean selectingAndSortingUnspecifiedFields) {
        this.selectingAndSortingUnspecifiedFields = selectingAndSortingUnspecifiedFields;
    }

    public SelectMetadataChange[] getMeta() {
        return this.meta;
    }

    public void setMeta(SelectMetadataChange[] meta) {
        this.meta = meta == null ? new SelectMetadataChange[]{} : meta;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public SelectField[] getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(SelectField[] selectFields) {
        this.selectFields = selectFields == null ? new SelectField[]{} : selectFields;
    }

    public List<FieldnameLineage> getFieldnameLineage() {
        String output;
        String input;
        int i;
        ArrayList<FieldnameLineage> lineages = new ArrayList<FieldnameLineage>();
        for (i = 0; i < this.selectFields.length; ++i) {
            input = this.selectFields[i].getName();
            output = this.selectFields[i].getRename();
            if (Utils.isEmpty((CharSequence)output) || input.equalsIgnoreCase(output)) continue;
            lineages.add(new FieldnameLineage(input, output));
        }
        for (i = 0; i < this.getMeta().length; ++i) {
            input = this.getMeta()[i].getName();
            output = this.getMeta()[i].getRename();
            if (Utils.isEmpty((CharSequence)output) || input.equalsIgnoreCase(output)) continue;
            int idx = Const.indexOfString((String)input, (String[])this.getSelectRename());
            if (idx < 0) {
                lineages.add(new FieldnameLineage(input, output));
                continue;
            }
            FieldnameLineage lineage = FieldnameLineage.findFieldnameLineageWithInput(lineages, (String)input);
            lineage.setOutputFieldname(output);
        }
        return lineages;
    }

    public static class SelectField
    implements Cloneable {
        @Injection(name="FIELD_NAME", group="FIELDS")
        private String name;
        @Injection(name="FIELD_RENAME", group="FIELDS")
        private String rename;
        @Injection(name="FIELD_LENGTH", group="FIELDS")
        private int length = -2;
        @Injection(name="FIELD_PRECISION", group="FIELDS")
        private int precision = -2;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRename() {
            return this.rename;
        }

        public void setRename(String rename) {
            this.rename = rename;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getPrecision() {
            return this.precision;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public SelectField clone() {
            try {
                return (SelectField)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

