/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

class ExecutionSlotSharingGroup {
    private final Set<ExecutionVertexID> executionVertexIds;
    private ResourceProfile resourceProfile = ResourceProfile.UNKNOWN;

    ExecutionSlotSharingGroup() {
        this.executionVertexIds = new HashSet<ExecutionVertexID>();
    }

    void addVertex(ExecutionVertexID executionVertexId) {
        this.executionVertexIds.add(executionVertexId);
    }

    void setResourceProfile(ResourceProfile resourceProfile) {
        this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile);
    }

    ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    Set<ExecutionVertexID> getExecutionVertexIds() {
        return Collections.unmodifiableSet(this.executionVertexIds);
    }

    public String toString() {
        return "ExecutionSlotSharingGroup{executionVertexIds=" + this.executionVertexIds + ", resourceProfile=" + this.resourceProfile + '}';
    }
}

