/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databasejoin.cache;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.row.IRowMeta;

public class DatabaseCache {
    private Map<RowMetaAndData, List<Object[]>> cache;

    public DatabaseCache(int maxSize) {
        this.cache = new EvictableCacheMap(maxSize);
    }

    public List<Object[]> getRowsFromCache(IRowMeta lookupMeta, Object[] lookupRow) {
        return this.getRowsFromCache(new RowMetaAndData(lookupMeta, lookupRow));
    }

    public List<Object[]> getRowsFromCache(RowMetaAndData key) {
        return this.cache.getOrDefault(key, null);
    }

    public void putRowsIntoCache(RowMetaAndData key, List<Object[]> values) {
        this.cache.put(key, values);
    }

    public void putRowsIntoCache(IRowMeta lookupMeta, Object[] lookupRow, List<Object[]> values) {
        this.putRowsIntoCache(new RowMetaAndData(lookupMeta, lookupRow), values);
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    private static class EvictableCacheMap
    extends LinkedHashMap<RowMetaAndData, List<Object[]>> {
        private final int maxSize;

        public EvictableCacheMap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<RowMetaAndData, List<Object[]>> eldest) {
            return this.maxSize > 0 && this.size() > this.maxSize;
        }
    }
}

