/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.language;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.language.DetectLanguage;
import org.apache.hop.pipeline.transforms.language.DetectLanguageData;

@Transform(id="DetectLanguage", image="detectlanguage.svg", name="i18n::DetectLanguage.Name", description="i18n::DetectLanguage.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::DetectLanguage.Keyword"}, documentationUrl="/pipeline/transforms/detectlanguage.html")
public class DetectLanguageMeta
extends BaseTransformMeta<DetectLanguage, DetectLanguageData> {
    private static final Class<?> PKG = DetectLanguageMeta.class;
    @HopMetadataProperty(key="corpusField", injectionKey="FIELD", injectionKeyDescription="DetectLanguage.Injection.CorpusField")
    private String corpusField;
    @HopMetadataProperty(key="parallelism", injectionKey="PARALLISM", injectionKeyDescription="DetectLanguage.Injection.Parallelism")
    private boolean parallelism = false;

    public void setDefault() {
        this.parallelism = false;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        this.valueMetaString(r, name, "detected_language");
        this.valueMetaNumber(r, name, "detected_language_confidence");
    }

    private void valueMetaString(IRowMeta r, String name, String metaName) {
        ValueMetaString sText = new ValueMetaString(metaName);
        sText.setOrigin(name);
        r.addValueMeta((IValueMeta)sText);
    }

    private void valueMetaNumber(IRowMeta r, String name, String metaName) {
        ValueMetaNumber sText = new ValueMetaNumber(metaName);
        sText.setOrigin(name);
        r.addValueMeta((IValueMeta)sText);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = Utils.isEmpty((CharSequence)this.corpusField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"DetectLanguageMeta.CheckResult.CorpusFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DetectLanguageMeta.CheckResult.CorpusFieldOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"DetectLanguageMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"DetectLanguageMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getCorpusField() {
        return this.corpusField;
    }

    public void setCorpusField(String corpusField) {
        this.corpusField = corpusField;
    }

    public boolean isParallelism() {
        return this.parallelism;
    }

    public void setParallelism(boolean parallelism) {
        this.parallelism = parallelism;
    }
}

