/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.metrics.DoFnRunnerWithMetricsUpdate;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.runners.flink.translation.functions.FlinkNoOpStepContext;
import org.apache.beam.runners.flink.translation.functions.FlinkSideInputReader;
import org.apache.beam.runners.flink.translation.utils.Workarounds;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class FlinkDoFnFunction<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
extends AbstractRichFunction
implements FlatMapFunction<WindowedValue<InputT>, WindowedValue<RawUnionValue>> {
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions serializedOptions;
    private final @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn;
    private final @UnknownKeyFor @NonNull @Initialized String stepName;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> sideInputs;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> outputMap;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag;
    private final @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoderMap;
    private final @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;
    private transient @UnknownKeyFor @NonNull @Initialized CollectorAware collectorAware;
    private transient @UnknownKeyFor @NonNull @Initialized DoFnInvoker<InputT, OutputT> doFnInvoker;
    private transient @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> doFnRunner;
    private transient @UnknownKeyFor @NonNull @Initialized FlinkMetricContainer metricContainer;
    private @UnknownKeyFor @NonNull @Initialized boolean bundleStarted = false;
    private @UnknownKeyFor @NonNull @Initialized boolean exceptionThrownInFlatMap = false;

    public FlinkDoFnFunction(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn, @UnknownKeyFor @NonNull @Initialized String stepName, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> outputMap, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoderMap, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
        this.doFn = doFn;
        this.stepName = stepName;
        this.sideInputs = sideInputs;
        this.serializedOptions = new SerializablePipelineOptions(options);
        this.windowingStrategy = windowingStrategy;
        this.outputMap = outputMap;
        this.mainOutputTag = mainOutputTag;
        this.inputCoder = inputCoder;
        this.outputCoderMap = outputCoderMap;
        this.doFnSchemaInformation = doFnSchemaInformation;
        this.sideInputMapping = sideInputMapping;
    }

    public void flatMap(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> value, @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized RawUnionValue>> out) {
        try {
            if (!this.bundleStarted) {
                this.bundleStarted = true;
                this.doFnRunner.startBundle();
            }
            this.collectorAware.setCollector(out);
            this.doFnRunner.processElement(value);
        }
        catch (Exception e) {
            this.exceptionThrownInFlatMap = true;
            throw e;
        }
    }

    public void open(@UnknownKeyFor @NonNull @Initialized Configuration parameters) {
        PipelineOptions options = this.serializedOptions.get();
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        this.doFnInvoker = DoFnInvokers.tryInvokeSetupFor(this.doFn, (PipelineOptions)options);
        this.metricContainer = new FlinkMetricContainer(this.getRuntimeContext());
        RuntimeContext runtimeContext = this.getRuntimeContext();
        DoFnRunners.OutputManager outputManager = this.outputMap.size() == 1 ? new DoFnOutputManager() : new MultiDoFnOutputManager(this.outputMap);
        ArrayList additionalOutputTags = Lists.newArrayList(this.outputMap.keySet());
        DoFnRunnerWithMetricsUpdate doFnRunner = DoFnRunners.simpleRunner((PipelineOptions)options, this.doFn, (SideInputReader)new FlinkSideInputReader(this.sideInputs, runtimeContext), (DoFnRunners.OutputManager)outputManager, this.mainOutputTag, (List)additionalOutputTags, (StepContext)new FlinkNoOpStepContext(), this.inputCoder, this.outputCoderMap, this.windowingStrategy, (DoFnSchemaInformation)this.doFnSchemaInformation, this.sideInputMapping);
        if (!((FlinkPipelineOptions)this.serializedOptions.get().as(FlinkPipelineOptions.class)).getDisableMetrics().booleanValue()) {
            doFnRunner = new DoFnRunnerWithMetricsUpdate(this.stepName, doFnRunner, this.metricContainer);
        }
        this.collectorAware = outputManager;
        this.doFnRunner = doFnRunner;
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Exception suppressed = null;
        try {
            if (this.bundleStarted && !this.exceptionThrownInFlatMap) {
                this.doFnRunner.finishBundle();
            }
        }
        catch (Exception e) {
            suppressed = e;
        }
        try {
            this.metricContainer.registerMetricsForPipelineResult();
            Optional.ofNullable(this.doFnInvoker).ifPresent(DoFnInvoker::invokeTeardown);
            if (suppressed != null) {
                throw suppressed;
            }
        }
        finally {
            Workarounds.deleteStaticCaches();
        }
    }

    static class MultiDoFnOutputManager
    implements DoFnRunners.OutputManager,
    CollectorAware {
        private @Nullable @UnknownKeyFor @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized RawUnionValue>> collector;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> outputMap;

        MultiDoFnOutputManager(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> outputMap) {
            this.outputMap = outputMap;
        }

        MultiDoFnOutputManager(@Nullable @UnknownKeyFor @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized RawUnionValue>> collector, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> outputMap) {
            this.collector = collector;
            this.outputMap = outputMap;
        }

        @Override
        public void setCollector(@UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized RawUnionValue>> collector) {
            this.collector = Objects.requireNonNull(collector);
        }

        public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
            Objects.requireNonNull(this.collector).collect((Object)WindowedValue.of((Object)new RawUnionValue(this.outputMap.get(tag).intValue(), output.getValue()), (Instant)output.getTimestamp(), (Collection)output.getWindows(), (PaneInfo)output.getPane()));
        }
    }

    static class DoFnOutputManager
    implements DoFnRunners.OutputManager,
    CollectorAware {
        private @Nullable @UnknownKeyFor @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized RawUnionValue>> collector;

        DoFnOutputManager() {
            this(null);
        }

        DoFnOutputManager(@Nullable @UnknownKeyFor @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized RawUnionValue>> collector) {
            this.collector = collector;
        }

        @Override
        public void setCollector(@UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized RawUnionValue>> collector) {
            this.collector = Objects.requireNonNull(collector);
        }

        public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
            Objects.requireNonNull(this.collector).collect((Object)WindowedValue.of((Object)new RawUnionValue(0, output.getValue()), (Instant)output.getTimestamp(), (Collection)output.getWindows(), (PaneInfo)output.getPane()));
        }
    }

    static interface CollectorAware {
        public void setCollector(@UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized RawUnionValue>> var1);
    }
}

