/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.gs;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.vfs.gs.GoogleStorageFileName;
import org.apache.hop.vfs.gs.GoogleStorageFileSystem;
import org.apache.hop.vfs.gs.ReadChannelInputStream;
import org.apache.hop.vfs.gs.WriteChannelOutputStream;

public class GoogleStorageFileObject
extends AbstractFileObject<GoogleStorageFileSystem> {
    Blob blob = null;
    Bucket bucket = null;
    String bucketName = ((GoogleStorageFileSystem)this.getAbstractFileSystem()).getBucketName(this.getName()).trim();
    String bucketPath = ((GoogleStorageFileSystem)this.getAbstractFileSystem()).getBucketPath(this.getName()).trim();

    protected GoogleStorageFileObject(AbstractFileName name, GoogleStorageFileSystem fs) {
        super(name, (AbstractFileSystem)fs);
    }

    protected GoogleStorageFileObject(AbstractFileName name, GoogleStorageFileSystem fs, Bucket bucket, Blob blob) {
        super(name, (AbstractFileSystem)fs);
        this.bucket = bucket;
        this.blob = blob;
    }

    private boolean hasBucket() {
        return this.bucket != null;
    }

    private boolean hasObject() {
        return this.blob != null;
    }

    protected void doAttach() throws Exception {
        Storage storage = ((GoogleStorageFileSystem)this.getAbstractFileSystem()).setupStorage();
        if (this.bucketName.length() > 0) {
            if (this.bucket == null) {
                this.bucket = storage.get(this.bucketName, new Storage.BucketGetOption[0]);
            }
            if (this.bucketPath.length() > 0 && this.blob == null) {
                this.blob = storage.get(this.bucketName, this.bucketPath, new Storage.BlobGetOption[0]);
                if (this.blob == null) {
                    String parent = this.getParentFolder(this.bucketPath);
                    String child = this.lastPathElement(this.stripTrailingSlash(this.bucketPath));
                    Page page = parent.length() > 0 ? storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.prefix((String)(parent + "/"))}) : storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory()});
                    for (Blob b : page.iterateAll()) {
                        if (!this.lastPathElement(this.stripTrailingSlash(b.getName())).equals(child)) continue;
                        this.blob = b;
                        break;
                    }
                }
            }
        }
    }

    protected long doGetContentSize() throws Exception {
        return this.hasObject() ? this.blob.getSize() : 0L;
    }

    protected InputStream doGetInputStream() throws Exception {
        if (!this.isFile()) {
            throw new FileNotFoundException();
        }
        Storage storage = ((GoogleStorageFileSystem)this.getAbstractFileSystem()).setupStorage();
        return new ReadChannelInputStream(storage.reader(this.blob.getBlobId(), new Storage.BlobSourceOption[0]));
    }

    protected FileType doGetType() throws Exception {
        if (this.getName() instanceof GoogleStorageFileName) {
            return this.getName().getType();
        }
        if (this.hasBucket()) {
            if (this.hasObject()) {
                return this.blob.isDirectory() ? FileType.FOLDER : FileType.FILE;
            }
            if (this.bucketPath.length() == 0) {
                return FileType.FOLDER;
            }
            return FileType.IMAGINARY;
        }
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        if (!this.isFolder()) {
            throw new IOException("Object is not a directory");
        }
        Storage storage = ((GoogleStorageFileSystem)this.getAbstractFileSystem()).setupStorage();
        ArrayList<String> results = new ArrayList<String>();
        if (!this.hasBucket()) {
            Page page = storage.list(new Storage.BucketListOption[0]);
            for (Bucket b : page.iterateAll()) {
                results.add(b.getName());
            }
        } else {
            Page page = this.bucketPath.length() > 0 ? storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.prefix((String)this.appendTrailingSlash(this.bucketPath))}) : storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory()});
            for (Blob b : page.iterateAll()) {
                results.add(this.lastPathElement(this.stripTrailingSlash(b.getName())));
            }
        }
        return results.toArray(new String[0]);
    }

    protected void doCreateFolder() throws Exception {
        Storage storage = ((GoogleStorageFileSystem)this.getAbstractFileSystem()).setupStorage();
        if (!this.hasBucket()) {
            this.bucket = storage.create(BucketInfo.newBuilder((String)this.bucketName).build(), new Storage.BucketTargetOption[0]);
        } else {
            this.blob = storage.create(BlobInfo.newBuilder((BucketInfo)this.bucket, (String)this.appendTrailingSlash(this.bucketPath)).build(), new Storage.BlobTargetOption[0]);
        }
    }

    protected void doDelete() throws Exception {
        if (!this.hasObject()) {
            throw new IOException("Object is not attached");
        }
        if (!this.blob.delete(new Blob.BlobSourceOption[0])) {
            throw new IOException("Failed to delete object '" + String.valueOf((Object)this) + "' (not found)");
        }
    }

    protected void doDetach() throws Exception {
        this.bucket = null;
        this.blob = null;
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.hasObject()) {
            if (this.isFolder()) {
                return 0L;
            }
            return this.blob.getUpdateTime();
        }
        if (this.hasBucket()) {
            return this.bucket.getCreateTime();
        }
        return 0L;
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        if (this.isFolder()) {
            throw new IOException("Object is a directory or bucket");
        }
        if (!this.hasBucket()) {
            throw new IOException("Object must be placed in bucket");
        }
        if (this.bucketPath.length() == 0) {
            throw new IOException("Object needs a path within the bucket");
        }
        Storage storage = ((GoogleStorageFileSystem)this.getAbstractFileSystem()).setupStorage();
        if (!this.hasObject()) {
            this.blob = storage.create(BlobInfo.newBuilder((BucketInfo)this.bucket, (String)this.stripTrailingSlash(this.bucketPath)).build(), new Storage.BlobTargetOption[0]);
        }
        return new WriteChannelOutputStream(storage.writer((BlobInfo)this.blob, new Storage.BlobWriteOption[0]));
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        if (!this.isFolder()) {
            throw new IOException("Object is not a directory");
        }
        Storage storage = ((GoogleStorageFileSystem)this.getAbstractFileSystem()).setupStorage();
        ArrayList<GoogleStorageFileObject> results = new ArrayList<GoogleStorageFileObject>();
        if (!this.hasBucket()) {
            Page page = storage.list(new Storage.BucketListOption[0]);
            for (Bucket b : page.iterateAll()) {
                results.add(new GoogleStorageFileObject(new GoogleStorageFileName(b.getName(), FileType.FOLDER), (GoogleStorageFileSystem)this.getAbstractFileSystem()));
            }
        } else {
            Page page = this.bucketPath.length() > 0 ? storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.prefix((String)this.appendTrailingSlash(this.bucketPath))}) : storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory()});
            for (Blob b : page.iterateAll()) {
                if (this.blob != null && b.getName().equals(this.blob.getName())) continue;
                results.add(new GoogleStorageFileObject(new GoogleStorageFileName(this.getName().getPath() + "/" + this.lastPathElement(this.stripTrailingSlash(b.getName())), b.isDirectory() ? FileType.FOLDER : FileType.FILE), (GoogleStorageFileSystem)this.getAbstractFileSystem(), this.bucket != null ? this.bucket : storage.get(this.bucketName, new Storage.BucketGetOption[0]), b));
            }
        }
        return results.toArray(new FileObject[0]);
    }

    String getParentFolder(String name) {
        int idx = (name = this.stripTrailingSlash(name)).lastIndexOf(47);
        if (idx > -1) {
            return name.substring(0, idx);
        }
        return "";
    }

    boolean hasTrailingSlash(String name) {
        return name.endsWith("/");
    }

    String stripTrailingSlash(String name) {
        if (name.endsWith("/")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    String appendTrailingSlash(String name) {
        if (!name.endsWith("/")) {
            return name + "/";
        }
        return name;
    }

    String lastPathElement(String name) {
        int idx = name.lastIndexOf(47);
        if (idx > -1) {
            return name.substring(idx + 1);
        }
        return name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GoogleStorageFileObject that = (GoogleStorageFileObject)((Object)o);
        return Objects.equals(this.getName().getPath(), that.getName().getPath());
    }

    public int hashCode() {
        return Objects.hash(this.getName().getPath());
    }
}

