/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms.providers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class StringCompiler {
    private static final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized String> classpathSupplier = Suppliers.memoize(() -> {
        ArrayList<String> cp = new ArrayList<String>();
        cp.add(System.getProperty("java.class.path"));
        ClassLoader cl = StringCompiler.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                File file = new File(url.getFile());
                if (!file.exists() || file.isDirectory()) continue;
                try (ZipFile zipFile = new ZipFile(new File(url.getFile()));){
                    ZipEntry manifestEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
                    if (manifestEntry == null) continue;
                    Manifest manifest = new Manifest(zipFile.getInputStream(manifestEntry));
                    cp.add(manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH));
                }
                catch (IOException exn) {
                    throw new RuntimeException(exn);
                }
            }
        }
        return String.join((CharSequence)System.getProperty("path.separator"), cp);
    });

    public static <T> @UnknownKeyFor @NonNull @Initialized Class<T> getClass(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String source) throws @UnknownKeyFor @NonNull @Initialized CompileException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        DiagnosticCollector diagnostics;
        InMemoryFileManager fileManager;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager = new InMemoryFileManager(compiler.getStandardFileManager(null, null, null)), diagnostics = new DiagnosticCollector(), (Iterable<String>)ImmutableList.of((Object)"-classpath", (Object)classpathSupplier.get()), null, Collections.singletonList(new InMemoryFileManager.InputJavaFileObject(name, source)));
        boolean result = task.call();
        if (!result) {
            throw new CompileException(diagnostics);
        }
        return fileManager.getClassLoader().loadClass(name);
    }

    public static @UnknownKeyFor @NonNull @Initialized Object getInstance(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String source) throws @UnknownKeyFor @NonNull @Initialized CompileException, @UnknownKeyFor @NonNull @Initialized ReflectiveOperationException {
        return StringCompiler.getClass(name, source).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static @UnknownKeyFor @NonNull @Initialized Type guessExpressionType(@UnknownKeyFor @NonNull @Initialized String expression, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Type> inputTypes) throws @UnknownKeyFor @NonNull @Initialized CompileException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        String expectedError = "cannot be converted to __TypeGuesserHelper__.BadReturnType";
        try {
            StringCompiler.getClass("__TypeGuesserHelper__", StringCompiler.typeGuesserSource(expression, inputTypes, "BadReturnType"));
            return Void.class;
        }
        catch (CompileException exn) {
            for (Diagnostic<?> d : exn.getDiagnostics().getDiagnostics()) {
                String msg = d.getMessage(Locale.ROOT);
                int expectedErrorIndex = msg.indexOf(expectedError);
                if (expectedErrorIndex == -1) continue;
                String typeSource = msg.substring(1 + "incompatible types: ".length() + msg.lastIndexOf(10, expectedErrorIndex), expectedErrorIndex);
                Class clazz = StringCompiler.getClass("__TypeGuesserHelper__", StringCompiler.typeGuesserSource(expression, inputTypes, typeSource));
                for (Method method : clazz.getMethods()) {
                    if (!method.getName().equals("method")) continue;
                    return method.getGenericReturnType();
                }
                throw new RuntimeException("Unable to locate declared method.");
            }
            throw exn;
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String typeGuesserSource(@UnknownKeyFor @NonNull @Initialized String expression, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Type> inputTypes, @UnknownKeyFor @NonNull @Initialized String returnType) {
        StringBuilder source = new StringBuilder();
        source.append("class __TypeGuesserHelper__ {\n");
        source.append("  private static class BadReturnType { private BadReturnType() {} }\n");
        source.append("  public static " + returnType + " method(\n");
        boolean first = true;
        for (Map.Entry<String, Type> arg : inputTypes.entrySet()) {
            if (first) {
                first = false;
            } else {
                source.append(", ");
            }
            source.append(arg.getValue().getTypeName() + " " + arg.getKey());
        }
        source.append("    ) {\n");
        source.append("    return " + expression + ";\n");
        source.append("  }\n");
        source.append("}\n");
        return source.toString();
    }

    private static class InMemoryFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputJavaFileObject> outputFileObjects = new HashMap<String, OutputJavaFileObject>();

        public InMemoryFileManager(@UnknownKeyFor @NonNull @Initialized StandardJavaFileManager standardManager) {
            super(standardManager);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized JavaFileObject getJavaFileForOutput( @UnknownKeyFor @NonNull @Initialized JavaFileManager.Location location, @UnknownKeyFor @NonNull @Initialized String className, @UnknownKeyFor @NonNull @Initialized JavaFileObject.Kind kind, @UnknownKeyFor @NonNull @Initialized FileObject sibling) {
            OutputJavaFileObject classAsBytes = new OutputJavaFileObject(className, kind);
            this.outputFileObjects.put(className, classAsBytes);
            return classAsBytes;
        }

        public @UnknownKeyFor @NonNull @Initialized ClassLoader getClassLoader() {
            return AccessController.doPrivileged(() -> new SecureClassLoader(){

                @Override
                protected /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findClass(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
                    OutputJavaFileObject fileObject = (OutputJavaFileObject)outputFileObjects.get(name);
                    if (fileObject == null) {
                        throw new ClassNotFoundException(name);
                    }
                    byte[] classBytes = fileObject.getBytes();
                    return this.defineClass(name, classBytes, 0, classBytes.length);
                }
            });
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ClassLoader getClassLoader( @UnknownKeyFor @NonNull @Initialized JavaFileManager.Location location) {
            return this.getClassLoader();
        }

        private static class OutputJavaFileObject
        extends SimpleJavaFileObject {
            private @UnknownKeyFor @NonNull @Initialized ByteArrayOutputStream content = new ByteArrayOutputStream();

            public OutputJavaFileObject(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized JavaFileObject.Kind kind) {
                super(URI.create("output:///" + name.replace('.', '/') + kind.extension), kind);
            }

            public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getBytes() {
                return this.content.toByteArray();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized OutputStream openOutputStream() {
                return this.content;
            }
        }

        private static class InputJavaFileObject
        extends SimpleJavaFileObject {
            private @UnknownKeyFor @NonNull @Initialized String source;

            public InputJavaFileObject(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String source) {
                super(URI.create("input:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
                this.source = source;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized CharSequence getCharContent(@UnknownKeyFor @NonNull @Initialized boolean ignoreEncodingErrors) {
                return this.source;
            }
        }
    }

    public static class CompileException
    extends Exception {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DiagnosticCollector<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> diagnostics;

        public CompileException(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DiagnosticCollector<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> diagnostics) {
            super(diagnostics.getDiagnostics().toString());
            this.diagnostics = diagnostics;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DiagnosticCollector<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getDiagnostics() {
            return this.diagnostics;
        }
    }
}

