/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.mailvalidator;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.actions.mailvalidator.MailValidation;
import org.apache.hop.workflow.actions.mailvalidator.MailValidationResult;

@Action(id="MAIL_VALIDATOR", name="i18n::ActionMailValidator.Name", description="i18n::ActionMailValidator.Description", image="MailValidator.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Mail", documentationUrl="/workflow/actions/mailvalidator.html")
public class ActionMailValidator
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionMailValidator.class;
    @HopMetadataProperty
    private boolean smtpCheck = false;
    @HopMetadataProperty
    private String timeout = "0";
    @HopMetadataProperty
    private String defaultSMTP = null;
    @HopMetadataProperty
    private String emailSender = "noreply@domain.com";
    @HopMetadataProperty
    private String emailAddress = null;

    public ActionMailValidator(String n, String scr) {
        super(n, "");
    }

    public ActionMailValidator() {
        this("", "");
    }

    public void setSmtpCheck(boolean smtpcheck) {
        this.smtpCheck = smtpcheck;
    }

    public boolean isSmtpCheck() {
        return this.smtpCheck;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getDefaultSMTP() {
        return this.defaultSMTP;
    }

    public void setDefaultSMTP(String defaultSMTP) {
        this.defaultSMTP = defaultSMTP;
    }

    public String getEmailSender() {
        return this.emailSender;
    }

    public void setEmailSender(String emailSender) {
        this.emailSender = emailSender;
    }

    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String realEmailAddress = this.resolve(this.emailAddress);
        if (Utils.isEmpty((CharSequence)realEmailAddress)) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionMailValidator.Error.EmailEmpty", (String[])new String[0]));
            return result;
        }
        String realSender = this.resolve(this.emailSender);
        if (this.smtpCheck && Utils.isEmpty((CharSequence)realSender)) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionMailValidator.Error.EmailSenderEmpty", (String[])new String[0]));
            return result;
        }
        String realDefaultSMTP = this.resolve(this.defaultSMTP);
        int timeOut = Const.toInt((String)this.resolve(this.timeout), (int)0);
        String[] mailsCheck = realEmailAddress.split(" ");
        boolean exitloop = false;
        boolean mailIsValid = false;
        String mailError = null;
        for (int i = 0; i < mailsCheck.length && !exitloop; ++i) {
            String email = mailsCheck[i];
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMailValidator.CheckingMail", (String[])new String[]{email}));
            }
            MailValidationResult resultValidator = MailValidation.isAddressValid(this.getLogChannel(), email, realSender, realDefaultSMTP, timeOut, this.smtpCheck);
            mailIsValid = resultValidator.isValide();
            mailError = resultValidator.getErrorMessage();
            if (this.isDetailed()) {
                if (mailIsValid) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMailValidator.MailValid", (String[])new String[]{email}));
                } else {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMailValidator.MailNotValid", (String[])new String[]{email}));
                    this.logDetailed(mailError);
                }
            }
            if (resultValidator.isValide()) continue;
            exitloop = true;
        }
        result.setResult(mailIsValid);
        if (mailIsValid) {
            result.setNrErrors(0L);
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "emailAddress", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "emailSender", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.emailValidator()}));
        if (this.isSmtpCheck()) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "defaultSMTP", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        }
    }
}

