/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp.compiler;

import java.util.Stack;

class GroovyPageExpressionParser {
    String scriptTokens;
    int startPos;
    char terminationChar;
    char nextTerminationChar;
    Stack<ParsingState> parsingStateStack = new Stack();
    boolean containsGstrings = false;
    int terminationCharPos = -1;
    int relativeCharIndex = 0;

    public GroovyPageExpressionParser(String scriptTokens, int startPos, char terminationChar, char nextTerminationChar, boolean startInExpression) {
        this.scriptTokens = scriptTokens;
        this.startPos = startPos;
        this.terminationChar = terminationChar;
        this.nextTerminationChar = nextTerminationChar;
        if (startInExpression) {
            this.parsingStateStack.push(ParsingState.EXPRESSION);
        } else {
            this.parsingStateStack.push(ParsingState.NORMAL);
        }
    }

    int parse() {
        int currentPos = this.startPos;
        char previousChar = '\u0000';
        char previousPreviousChar = '\u0000';
        while (currentPos < this.scriptTokens.length() && this.terminationCharPos == -1) {
            char nextChar;
            ParsingState parsingState = this.parsingStateStack.peek();
            char ch = this.scriptTokens.charAt(currentPos++);
            char c = nextChar = currentPos < this.scriptTokens.length() ? this.scriptTokens.charAt(currentPos) : (char)'\u0000';
            if (this.parsingStateStack.size() == 1 && ch == this.terminationChar && (this.nextTerminationChar == '\u0000' || this.nextTerminationChar == nextChar)) {
                this.terminationCharPos = currentPos - 1;
            } else if (parsingState == ParsingState.EXPRESSION || parsingState == ParsingState.NORMAL) {
                switch (ch) {
                    case '{': {
                        if (previousChar == '$' && parsingState == ParsingState.EXPRESSION) {
                            return -1;
                        }
                        if (previousChar != '$' && parsingState != ParsingState.EXPRESSION) break;
                        this.changeState(ParsingState.EXPRESSION);
                        break;
                    }
                    case '[': {
                        if (this.relativeCharIndex != 0 && parsingState != ParsingState.EXPRESSION) break;
                        this.changeState(ParsingState.EXPRESSION);
                        break;
                    }
                    case ']': 
                    case '}': {
                        if (parsingState != ParsingState.EXPRESSION) break;
                        this.parsingStateStack.pop();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        if (parsingState != ParsingState.EXPRESSION) break;
                        if (nextChar != ch && previousChar != ch) {
                            this.changeState(ch == '\"' ? ParsingState.QUOTEDVALUE_DOUBLE : ParsingState.QUOTEDVALUE_SINGLE);
                            break;
                        }
                        if (previousChar != ch || previousPreviousChar != ch) break;
                        this.changeState(ch == '\"' ? ParsingState.TRIPLEQUOTED_DOUBLE : ParsingState.TRIPLEQUOTED_SINGLE);
                    }
                }
            } else if (ch == '\"' || ch == '\'') {
                if (nextChar != ch && (previousChar != ch || previousPreviousChar == '\\') && (previousChar != '\\' || previousChar == '\\' && previousPreviousChar == '\\') && (parsingState == ParsingState.QUOTEDVALUE_DOUBLE && ch == '\"' || parsingState == ParsingState.QUOTEDVALUE_SINGLE && ch == '\'')) {
                    this.parsingStateStack.pop();
                } else if (previousChar == ch && previousPreviousChar == ch && (parsingState == ParsingState.TRIPLEQUOTED_DOUBLE && ch == '\"' || parsingState == ParsingState.TRIPLEQUOTED_SINGLE && ch == '\'')) {
                    this.parsingStateStack.pop();
                }
            }
            previousPreviousChar = previousChar;
            previousChar = ch;
            ++this.relativeCharIndex;
        }
        return this.terminationCharPos;
    }

    private void changeState(ParsingState newState) {
        ParsingState currentState = this.parsingStateStack.peek();
        if (this.relativeCharIndex > 1 && newState == ParsingState.EXPRESSION && (currentState == ParsingState.QUOTEDVALUE_DOUBLE || currentState == ParsingState.TRIPLEQUOTED_DOUBLE || currentState == ParsingState.NORMAL)) {
            this.containsGstrings = true;
        }
        this.parsingStateStack.push(newState);
    }

    public boolean isContainsGstrings() {
        return this.containsGstrings;
    }

    public int getTerminationCharPos() {
        return this.terminationCharPos;
    }

    private static enum ParsingState {
        NORMAL,
        EXPRESSION,
        QUOTEDVALUE_SINGLE,
        QUOTEDVALUE_DOUBLE,
        TRIPLEQUOTED_SINGLE,
        TRIPLEQUOTED_DOUBLE;

    }
}

