/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.DefaultElementQuery;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public interface ElementQuery<T extends Element> {
    public static final ElementQuery<ClassElement> ALL_INNER_CLASSES = ElementQuery.of(ClassElement.class);
    public static final ElementQuery<FieldElement> ALL_FIELDS = ElementQuery.of(FieldElement.class);
    public static final ElementQuery<MethodElement> ALL_METHODS = ElementQuery.of(MethodElement.class);
    public static final ElementQuery<ConstructorElement> CONSTRUCTORS = ElementQuery.of(ConstructorElement.class).onlyDeclared();

    @NonNull
    public ElementQuery<T> onlyDeclared();

    public ElementQuery<T> onlyInjected();

    @NonNull
    public ElementQuery<T> onlyConcrete();

    @NonNull
    public ElementQuery<T> onlyAbstract();

    @NonNull
    public ElementQuery<T> onlyAccessible();

    @NonNull
    public ElementQuery<T> onlyAccessible(ClassElement var1);

    public ElementQuery<T> onlyInstance();

    public ElementQuery<T> includeEnumConstants();

    public ElementQuery<T> includeOverriddenMethods();

    public ElementQuery<T> includeHiddenElements();

    @NonNull
    public ElementQuery<T> named(@NonNull Predicate<String> var1);

    @NonNull
    default public ElementQuery<T> named(@NonNull String name) {
        return this.named((String n) -> n.equals(name));
    }

    @NonNull
    public ElementQuery<T> typed(@NonNull Predicate<ClassElement> var1);

    @NonNull
    public ElementQuery<T> annotated(@NonNull Predicate<AnnotationMetadata> var1);

    @NonNull
    public ElementQuery<T> modifiers(@NonNull Predicate<Set<ElementModifier>> var1);

    @NonNull
    public ElementQuery<T> filter(@NonNull Predicate<T> var1);

    @NonNull
    public Result<T> result();

    @NonNull
    public static <T1 extends Element> ElementQuery<T1> of(@NonNull Class<T1> elementType) {
        return new DefaultElementQuery<T1>(Objects.requireNonNull(elementType, "Element type cannot be null"));
    }

    public static interface Result<T extends Element> {
        public boolean isOnlyAbstract();

        public boolean isOnlyInjected();

        public boolean isOnlyConcrete();

        @NonNull
        public Class<T> getElementType();

        public boolean isOnlyAccessible();

        public Optional<ClassElement> getOnlyAccessibleFromType();

        public boolean isOnlyDeclared();

        public boolean isOnlyInstance();

        public boolean isIncludeEnumConstants();

        public boolean isIncludeOverriddenMethods();

        public boolean isIncludeHiddenElements();

        @NonNull
        public List<Predicate<String>> getNamePredicates();

        @NonNull
        public List<Predicate<ClassElement>> getTypePredicates();

        @NonNull
        public List<Predicate<AnnotationMetadata>> getAnnotationPredicates();

        @NonNull
        public List<Predicate<Set<ElementModifier>>> getModifierPredicates();

        @NonNull
        public List<Predicate<T>> getElementPredicates();
    }
}

