/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api;

import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.api.EventContext;

@FunctionalInterface
public interface EventFilter {
    public static final EventFilter ACCEPT_ALL = (event, context) -> true;
    public static final EventFilter REJECT_ALL = (event, context) -> false;

    public boolean accept(Event var1, EventContext var2);

    @SafeVarargs
    public static EventFilter byEventType(Class<? extends Event> ... eventTypes) {
        return (event, context) -> {
            for (Class eventType : eventTypes) {
                if (!eventType.isInstance(event)) continue;
                return true;
            }
            return false;
        };
    }
}

