/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.torque.Column;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.SqlEnum;

public class Criterion
implements Serializable {
    private static final long serialVersionUID = 7157097965404611710L;
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    private Object lValue;
    private SqlEnum comparison;
    private Object rValue;
    private String sql;
    private Object[] preparedStatementReplacements;
    private boolean ignoreCase = false;
    private List<Criterion> parts;
    private String conjunction;

    public Criterion(Object lValue, Object rValue, SqlEnum comparison, String sql, Object[] preparedStatementReplacements) {
        if (comparison != null && (sql != null || preparedStatementReplacements != null)) {
            throw new IllegalArgumentException("Either comparison or some of (sql, preparedStatementReplacements) can be not null, not both");
        }
        if ((lValue == null || comparison == null) && sql == null) {
            throw new IllegalArgumentException("Either the values(lValue, comparison) or sql must be not null");
        }
        this.lValue = lValue;
        this.comparison = comparison;
        this.rValue = rValue;
        this.sql = sql;
        this.preparedStatementReplacements = preparedStatementReplacements;
    }

    public Criterion(Object lValue, Object rValue) {
        this(lValue, rValue, Criteria.EQUAL, null, null);
    }

    public Criterion(Object lValue, Object rValue, SqlEnum comparison) {
        this(lValue, rValue, comparison, null, null);
    }

    public Criterion(Criterion toCopy) {
        this.lValue = toCopy.lValue;
        this.comparison = toCopy.comparison;
        this.rValue = toCopy.rValue;
        this.sql = toCopy.sql;
        this.preparedStatementReplacements = toCopy.preparedStatementReplacements;
        this.ignoreCase = toCopy.ignoreCase;
        if (toCopy.parts != null) {
            this.parts = new ArrayList<Criterion>(toCopy.parts.size());
            toCopy.parts.forEach(part -> this.parts.add(new Criterion((Criterion)part)));
        }
        this.conjunction = toCopy.conjunction;
    }

    public Object getLValue() {
        return this.lValue;
    }

    public void setLValue(Object lValue) {
        if (this.isComposite()) {
            throw new IllegalStateException("cannot set lValue for a composite Criterion");
        }
        this.lValue = lValue;
    }

    public SqlEnum getComparison() {
        return this.comparison;
    }

    public Object getRValue() {
        return this.rValue;
    }

    public void setRValue(Object rValue) {
        if (this.isComposite()) {
            throw new IllegalStateException("cannot set rValue for a composite Criterion");
        }
        this.rValue = rValue;
    }

    public String getSql() {
        return this.sql;
    }

    public Object[] getPreparedStatementReplacements() {
        return this.preparedStatementReplacements;
    }

    public boolean isVerbatimSqlCondition() {
        return this.sql != null;
    }

    public Criterion setIgnoreCase(boolean b) {
        if (this.isComposite()) {
            throw new IllegalStateException("cannot set ignoreCase for a composite Criterion");
        }
        this.ignoreCase = b;
        return this;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public List<Criterion> getParts() {
        if (this.parts == null) {
            return null;
        }
        return Collections.unmodifiableList(this.parts);
    }

    public String getConjunction() {
        return this.conjunction;
    }

    public boolean isComposite() {
        return this.parts != null;
    }

    public Criterion and(Criterion criterion) {
        this.addCompositeCriterion(criterion, AND);
        return this;
    }

    public Criterion or(Criterion criterion) {
        this.addCompositeCriterion(criterion, OR);
        return this;
    }

    private void addCompositeCriterion(Criterion criterion, String conjunction) {
        if (criterion == null) {
            throw new NullPointerException("criterion must not be null");
        }
        if (this.isComposite() && this.conjunction.equals(conjunction)) {
            this.parts.add(new Criterion(criterion));
        } else {
            Criterion copy = new Criterion(this);
            this.parts = new ArrayList<Criterion>();
            this.parts.add(copy);
            this.parts.add(new Criterion(criterion));
            this.conjunction = conjunction;
            this.rValue = null;
            this.comparison = null;
            this.lValue = null;
            this.sql = null;
            this.preparedStatementReplacements = null;
            this.ignoreCase = false;
        }
    }

    public void appendTo(StringBuilder sb) {
        if (this.isComposite()) {
            boolean first = true;
            for (Criterion part : this.parts) {
                if (!first) {
                    sb.append(this.conjunction);
                }
                if (part.isComposite()) {
                    sb.append('(');
                }
                part.appendTo(sb);
                if (part.isComposite()) {
                    sb.append(')');
                }
                first = false;
            }
        } else if (this.isVerbatimSqlCondition()) {
            sb.append(this.sql);
        } else {
            String lValueDisplay = this.lValue instanceof Column ? ((Column)this.lValue).getSqlExpression() : (this.lValue != null ? this.lValue.toString() : "");
            String rValueDisplay = this.rValue instanceof Column ? ((Column)this.rValue).getSqlExpression() : (this.rValue != null ? this.rValue.toString() : "");
            sb.append(lValueDisplay).append(this.comparison).append(rValueDisplay);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Criterion criterion = (Criterion)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append(criterion.lValue, this.lValue).append((Object)criterion.comparison, (Object)this.comparison).append(criterion.rValue, this.rValue).append((Object)criterion.sql, (Object)this.sql).append(criterion.preparedStatementReplacements, this.preparedStatementReplacements).append(criterion.ignoreCase, this.ignoreCase).append(criterion.parts, this.parts).append((Object)criterion.conjunction, (Object)this.conjunction);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append(this.lValue).append((Object)this.comparison).append(this.rValue).append((Object)this.sql).append(this.preparedStatementReplacements).append(this.ignoreCase).append(this.parts).append((Object)this.conjunction);
        return hashCodeBuilder.toHashCode();
    }
}

