/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.utils.net.HostNameUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheStartupServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RemoteCacheStartupServlet.class);
    private static final int DEFAULT_REGISTRY_PORT = 1101;
    private static final String DEFAULT_PROPS_FILE_NAME = "/cache.ccf";
    private String propsFileName = "/cache.ccf";
    private int registryPort = 1101;
    private String registryHost = null;

    public void init() throws ServletException {
        super.init();
        this.loadInitParams();
        Properties props = this.loadPropertiesFromFile();
        if (this.registryHost == null) {
            try {
                this.registryHost = HostNameUtil.getLocalHostAddress();
            }
            catch (UnknownHostException e) {
                log.error((Object)"Could not get local address to use for the registry!", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("registryHost = [" + this.registryHost + "]"));
        }
        if ("localhost".equals(this.registryHost) || "127.0.0.1".equals(this.registryHost)) {
            log.warn((Object)("The local address [" + this.registryHost + "] is INVALID.  Other machines must be able to use the address to reach this server."));
        }
        try {
            if (props == null) {
                throw new ServletException("Could not load configuration from " + this.propsFileName);
            }
            RemoteCacheServerFactory.startup(this.registryHost, this.registryPort, props);
            if (log.isInfoEnabled()) {
                log.info((Object)("Remote JCS Server started with properties from " + this.propsFileName));
            }
        }
        catch (IOException e) {
            throw new ServletException("Problem starting remote cache server.", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String stats = "";
        try {
            stats = CompositeCacheManager.getInstance().getStats();
        }
        catch (CacheException e) {
            throw new ServletException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)stats);
        }
        try {
            String characterEncoding = response.getCharacterEncoding();
            if (characterEncoding == null) {
                characterEncoding = "UTF-8";
                response.setCharacterEncoding(characterEncoding);
            }
            ServletOutputStream os = response.getOutputStream();
            os.write(stats.getBytes(characterEncoding));
            os.close();
        }
        catch (IOException e) {
            log.error((Object)"Problem writing response.", (Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
        log.info((Object)"Shutting down remote cache ");
        try {
            RemoteCacheServerFactory.shutdownImpl(this.registryHost, this.registryPort);
        }
        catch (IOException e) {
            log.error((Object)"Problem shutting down.", (Throwable)e);
        }
        try {
            CompositeCacheManager.getInstance().shutDown();
        }
        catch (CacheException e) {
            log.error((Object)"Could not retrieve cache manager instance", (Throwable)e);
        }
    }

    private Properties loadPropertiesFromFile() {
        Properties props = null;
        try {
            props = RemoteUtils.loadProps(this.propsFileName);
            if (props != null) {
                this.registryHost = props.getProperty("registry.host", this.registryHost);
                String portS = props.getProperty("registry.port", String.valueOf(this.registryPort));
                this.setRegistryPort(portS);
            }
        }
        catch (IOException e) {
            log.error((Object)"Problem loading props.", (Throwable)e);
        }
        return props;
    }

    private void loadInitParams() {
        String regPortString;
        String _registryHost;
        ServletConfig config = this.getServletConfig();
        String _propsFileName = config.getInitParameter("propsFileName");
        if (null != _propsFileName) {
            this.propsFileName = _propsFileName;
        }
        if (null != (_registryHost = config.getInitParameter("registryHost"))) {
            this.registryHost = _registryHost;
        }
        if (null != (regPortString = config.getInitParameter("registryPort"))) {
            this.setRegistryPort(regPortString);
        }
    }

    private void setRegistryPort(String portS) {
        try {
            this.registryPort = Integer.parseInt(portS);
        }
        catch (NumberFormatException e) {
            log.error((Object)"Problem converting port to an int.", (Throwable)e);
            this.registryPort = 1101;
        }
    }
}

