/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc.dsfactory;

import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp.datasources.InstanceKeyDataSource;
import org.apache.commons.dbcp.datasources.SharedPoolDataSource;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SharedPoolDataSourceFactory
implements DataSourceFactory {
    private static Log log = LogFactory.getLog(SharedPoolDataSourceFactory.class);
    private String name;
    private SharedPoolDataSource ds = null;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataSource getDataSource() {
        return this.ds;
    }

    @Override
    public void initialize(JDBCDiskCacheAttributes config) throws SQLException {
        this.name = config.getConnectionPoolName();
        ConnectionPoolDataSource cpds = this.initCPDS(config);
        SharedPoolDataSource dataSource = new SharedPoolDataSource();
        this.initJdbc2Pool((InstanceKeyDataSource)dataSource, config);
        dataSource.setConnectionPoolDataSource(cpds);
        dataSource.setMaxActive(config.getMaxActive());
        this.ds = dataSource;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.ds.close();
        }
        catch (Exception e) {
            throw new SQLException("Exception caught closing data source", e);
        }
        this.ds = null;
    }

    private ConnectionPoolDataSource initCPDS(JDBCDiskCacheAttributes config) throws SQLException {
        log.debug((Object)"Starting initCPDS");
        DriverAdapterCPDS cpds = new DriverAdapterCPDS();
        try {
            cpds.setDriver(config.getDriverClassName());
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Driver class not found " + config.getDriverClassName(), e);
        }
        cpds.setUrl(config.getUrl());
        cpds.setUser(config.getUserName());
        cpds.setPassword(config.getPassword());
        cpds.setMaxActive(config.getMaxActive());
        return cpds;
    }

    private void initJdbc2Pool(InstanceKeyDataSource dataSource, JDBCDiskCacheAttributes config) throws SQLException {
        log.debug((Object)"Starting initJdbc2Pool");
        dataSource.setDescription(config.getConnectionPoolName());
    }
}

