/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public record ETag(String tag, boolean weak) {
    private static final Log logger = LogFactory.getLog(ETag.class);
    private static final ETag WILDCARD = new ETag("*", false);

    public boolean isWildcard() {
        return this == WILDCARD;
    }

    public String formattedTag() {
        if (this.isWildcard()) {
            return "*";
        }
        return (this.weak ? "W/" : "") + "\"" + this.tag + "\"";
    }

    @Override
    public String toString() {
        return this.formattedTag();
    }

    public static List<ETag> parse(String source) {
        ArrayList<ETag> result = new ArrayList<ETag>();
        State state = State.BEFORE_QUOTES;
        int startIndex = -1;
        boolean weak = false;
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (state == State.IN_QUOTES) {
                if (c != '\"') continue;
                String tag = source.substring(startIndex, i);
                if (StringUtils.hasText((String)tag)) {
                    result.add(new ETag(tag, weak));
                }
                state = State.AFTER_QUOTES;
                startIndex = -1;
                weak = false;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            if (c == ',') {
                state = State.BEFORE_QUOTES;
                continue;
            }
            if (state == State.BEFORE_QUOTES) {
                if (c == '*') {
                    result.add(WILDCARD);
                    state = State.AFTER_QUOTES;
                    continue;
                }
                if (c == '\"') {
                    state = State.IN_QUOTES;
                    startIndex = i + 1;
                    continue;
                }
                if (c == 'W' && source.length() > i + 2 && source.charAt(i + 1) == '/' && source.charAt(i + 2) == '\"') {
                    state = State.IN_QUOTES;
                    startIndex = (i += 2) + 1;
                    weak = true;
                    continue;
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Unexpected char at index " + i));
        }
        if (state != State.IN_QUOTES && logger.isDebugEnabled()) {
            logger.debug((Object)"Expected closing '\"'");
        }
        return result;
    }

    private static enum State {
        BEFORE_QUOTES,
        IN_QUOTES,
        AFTER_QUOTES;

    }
}

